/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.type;

import java.util.Collection;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.IncidenceSetRef;
import org.hypergraphdb.LazyRef;
import org.hypergraphdb.type.HGAtomType;
import org.hypergraphdb.type.ObjectFactory;
import org.hypergraphdb.type.TypeUtils;

public class CollectionType
implements HGAtomType {
    private HyperGraph graph = null;
    private ObjectFactory<Collection<Object>> factory = null;

    public CollectionType(ObjectFactory<Collection<Object>> factory) {
        this.factory = factory;
    }

    @Override
    public void setHyperGraph(HyperGraph hg2) {
        this.graph = hg2;
    }

    public ObjectFactory<Collection<Object>> getFactory() {
        return this.factory;
    }

    @Override
    public Object make(HGPersistentHandle handle, LazyRef<HGHandle[]> targetSet, IncidenceSetRef incidenceSet) {
        Collection<Object> result = targetSet == null || targetSet.deref().length == 0 ? this.factory.make() : this.factory.make(targetSet.deref());
        TypeUtils.setValueFor(this.graph, handle, result);
        HGPersistentHandle[] layout = this.graph.getStore().getLink(handle);
        for (int i = 0; i < layout.length; i += 2) {
            Object current = null;
            HGPersistentHandle typeHandle = layout[i];
            HGPersistentHandle valueHandle = layout[i + 1];
            if (!typeHandle.equals(this.graph.getHandleFactory().nullHandle())) {
                HGAtomType type = this.graph.getTypeSystem().getType(typeHandle);
                current = TypeUtils.makeValue(this.graph, valueHandle, type);
            }
            result.add(current);
        }
        return result;
    }

    @Override
    public HGPersistentHandle store(Object instance) {
        HGPersistentHandle result = TypeUtils.getNewHandleFor(this.graph, instance);
        Collection collection = (Collection)instance;
        HGPersistentHandle[] layout = new HGPersistentHandle[collection.size() * 2];
        int pos = 0;
        for (Object curr : collection) {
            if (curr == null) {
                layout[pos++] = this.graph.getHandleFactory().nullHandle();
                layout[pos++] = this.graph.getHandleFactory().nullHandle();
                continue;
            }
            HGHandle typeHandle = this.graph.getTypeSystem().getTypeHandle(curr.getClass());
            layout[pos++] = this.graph.getPersistentHandle(typeHandle);
            layout[pos++] = TypeUtils.storeValue(this.graph, curr, this.graph.getTypeSystem().getType(typeHandle));
        }
        this.graph.getStore().store(result, layout);
        return result;
    }

    @Override
    public void release(HGPersistentHandle handle) {
        HGPersistentHandle[] layout = this.graph.getStore().getLink(handle);
        for (int i = 0; i < layout.length; i += 2) {
            HGPersistentHandle typeHandle = layout[i];
            HGPersistentHandle valueHandle = layout[i + 1];
            if (typeHandle.equals(this.graph.getHandleFactory().nullHandle()) || TypeUtils.isValueReleased(this.graph, valueHandle)) continue;
            HGAtomType type = (HGAtomType)this.graph.get(typeHandle);
            TypeUtils.releaseValue(this.graph, type, valueHandle);
            type.release(valueHandle);
        }
        this.graph.getStore().removeLink(handle);
    }

    @Override
    public boolean subsumes(Object general, Object specific) {
        return false;
    }
}

