/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.type;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.hypergraphdb.HGException;

public class BonesOfBeans {
    private static final Map<Class<?>, Class<?>> objectToPrimitiveMap = new HashMap(13);

    private static Map<String, PropertyDescriptor> getpropmap(Class<?> clazz) {
        return BonesOfBeans.getpropmap(clazz, false);
    }

    private static Map<String, PropertyDescriptor> getpropmap(Class<?> clazz, boolean incl_cls) {
        HashMap<String, PropertyDescriptor> propmap = null;
        if (propmap == null) {
            try {
                BeanInfo bean_info = Introspector.getBeanInfo(clazz);
                propmap = new HashMap<String, PropertyDescriptor>();
                PropertyDescriptor[] beanprops = bean_info.getPropertyDescriptors();
                for (int i = 0; i < beanprops.length; ++i) {
                    if (!incl_cls && "class".equals(beanprops[i].getName())) continue;
                    propmap.put(beanprops[i].getName(), beanprops[i]);
                }
            }
            catch (IntrospectionException ex) {
                throw new HGException("The bean " + clazz.getName() + " doesn't want us to introspect it: " + ex.toString());
            }
        }
        return propmap;
    }

    private static PropertyDescriptor getorthrow_propdesc(Object bean, String propname, int index) {
        PropertyDescriptor desc = BonesOfBeans.getPropertyDescriptor(bean, propname);
        if (desc == null) {
            throw new HGException("Property " + propname + " could not be found in bean " + bean.getClass().getName());
        }
        if (index >= 0 && !(desc instanceof IndexedPropertyDescriptor)) {
            throw new HGException("Property " + propname + " is not an indexed property in bean " + bean.getClass().getName());
        }
        return desc;
    }

    public static Map<String, PropertyDescriptor> getAllPropertyDescriptors(Class<?> beanClass) {
        return BonesOfBeans.getpropmap(beanClass);
    }

    public static Map<String, PropertyDescriptor> getAllPropertyDescriptorsEx(Class<?> beanClass) {
        return BonesOfBeans.getpropmap(beanClass, true);
    }

    public static Map<String, PropertyDescriptor> getAllPropertyDescriptors(Object bean) {
        return BonesOfBeans.getpropmap(bean.getClass());
    }

    public static PropertyDescriptor getPropertyDescriptor(Object bean, String propname) {
        return BonesOfBeans.getPropertyDescriptor(bean.getClass(), propname);
    }

    public static PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String propname) {
        return BonesOfBeans.getpropmap(clazz).get(propname);
    }

    public static Object getProperty(Object bean, PropertyDescriptor prop, int index) {
        try {
            Method method = null;
            if (prop instanceof IndexedPropertyDescriptor) {
                method = index < 0 ? prop.getReadMethod() : ((IndexedPropertyDescriptor)prop).getIndexedReadMethod();
            } else {
                if (index >= 0) {
                    throw new UnsupportedOperationException("Property " + prop.getName() + " of bean " + bean.getClass().getName() + " is not an indexed property.");
                }
                method = prop.getReadMethod();
            }
            if (method == null) {
                throw new UnsupportedOperationException("Property " + prop.getName() + " of bean " + bean.getClass().getName() + " is not readable.");
            }
            if (index < 0) {
                return method.invoke(bean, (Object[])null);
            }
            return method.invoke(bean, new Integer(index));
        }
        catch (IllegalAccessException ex) {
            throw new HGException("Illegal access to property " + prop.getName() + " of bean " + bean.getClass().getName() + " it is probably a private property: " + ex.toString());
        }
        catch (InvocationTargetException ex) {
            throw new HGException("InvocationTargetException while accessing property " + prop.getName() + " of bean " + bean.getClass().getName() + ex.toString() + ", target exception is " + ex.getTargetException().toString(), ex);
        }
    }

    public static Map<String, Object> getPropertiesAsMap(Object bean) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        Map<String, PropertyDescriptor> dm = BonesOfBeans.getAllPropertyDescriptors(bean);
        for (Map.Entry<String, PropertyDescriptor> e : dm.entrySet()) {
            if (e.getValue().getWriteMethod() == null || e.getValue().getReadMethod() == null) continue;
            m.put(e.getKey(), BonesOfBeans.getProperty(bean, e.getValue()));
        }
        return m;
    }

    public static void setPropertiesFromMap(Object bean, Map<String, Object> properties) {
        HashMap m = new HashMap();
        Map<String, PropertyDescriptor> dm = BonesOfBeans.getAllPropertyDescriptors(bean);
        for (Map.Entry<String, PropertyDescriptor> e : dm.entrySet()) {
            if (e.getValue().getWriteMethod() == null || e.getValue().getReadMethod() == null) continue;
            BonesOfBeans.setProperty(bean, e.getKey(), properties.get(e.getKey()));
        }
    }

    public static Object getProperty(Object bean, PropertyDescriptor prop) {
        return BonesOfBeans.getProperty(bean, prop, -1);
    }

    public static Object getProperty(Object bean, String propname, int index) {
        return BonesOfBeans.getProperty(bean, BonesOfBeans.getorthrow_propdesc(bean, propname, index), index);
    }

    public static Object getProperty(Object bean, String propname) {
        return BonesOfBeans.getProperty(bean, propname, -1);
    }

    public static void setProperty(Object bean, PropertyDescriptor prop, int index, Object newvalue) {
        try {
            Method method = null;
            if (prop instanceof IndexedPropertyDescriptor) {
                method = index < 0 ? prop.getWriteMethod() : ((IndexedPropertyDescriptor)prop).getIndexedWriteMethod();
            } else {
                if (index >= 0) {
                    throw new UnsupportedOperationException("Property " + prop.getName() + " of bean " + bean.getClass().getName() + " is not an indexed property.");
                }
                method = prop.getWriteMethod();
            }
            if (method == null) {
                throw new UnsupportedOperationException("Property " + prop.getName() + " of bean " + bean.getClass().getName() + " is not mutable (writeable).");
            }
            if (index < 0) {
                method.invoke(bean, newvalue);
            } else {
                method.invoke(bean, new Integer(index), newvalue);
            }
        }
        catch (IllegalAccessException ex) {
            throw new HGException("Illegal access to property " + prop.getName() + " of bean " + bean.getClass().getName() + " it is probably a private property: " + ex.toString());
        }
        catch (InvocationTargetException ex) {
            throw new HGException("InvocationTargetException while accessing property " + prop.getName() + " of bean " + bean.getClass().getName() + ex.toString() + ", taget exception is " + ex.getTargetException().toString(), ex);
        }
    }

    public static void setProperty(Object bean, PropertyDescriptor prop, Object newvalue) {
        BonesOfBeans.setProperty(bean, prop, -1, newvalue);
    }

    public static void setProperty(Object bean, String propname, int index, Object newvalue) {
        BonesOfBeans.setProperty(bean, BonesOfBeans.getorthrow_propdesc(bean, propname, index), index, newvalue);
    }

    public static void setProperty(Object bean, String propname, Object newvalue) {
        BonesOfBeans.setProperty(bean, propname, -1, newvalue);
    }

    public static Object makeBean(String classname) {
        try {
            Class<?> clazz = Class.forName(classname);
            return clazz.newInstance();
        }
        catch (Exception ex) {
            throw new HGException("Could not construct a bean DataObject from " + classname, ex);
        }
    }

    public static Class<?> primitiveEquivalentOf(Class<?> aClass) {
        return aClass.isPrimitive() ? aClass : objectToPrimitiveMap.get(aClass);
    }

    public static Class<?> wrapperEquivalentOf(Class<?> aClass) {
        for (Map.Entry<Class<?>, Class<?>> entry : objectToPrimitiveMap.entrySet()) {
            if (!aClass.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return aClass;
    }

    static {
        objectToPrimitiveMap.put(Boolean.class, Boolean.TYPE);
        objectToPrimitiveMap.put(Byte.class, Byte.TYPE);
        objectToPrimitiveMap.put(Character.class, Character.TYPE);
        objectToPrimitiveMap.put(Double.class, Double.TYPE);
        objectToPrimitiveMap.put(Float.class, Float.TYPE);
        objectToPrimitiveMap.put(Integer.class, Integer.TYPE);
        objectToPrimitiveMap.put(Long.class, Long.TYPE);
        objectToPrimitiveMap.put(Short.class, Short.TYPE);
    }
}

