/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.type;

import org.hypergraphdb.HGException;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.IncidenceSetRef;
import org.hypergraphdb.LazyRef;
import org.hypergraphdb.type.ArrayType;
import org.hypergraphdb.type.HGAtomType;

public class ArrayTypeConstructor
implements HGAtomType {
    private HyperGraph hg;

    @Override
    public void setHyperGraph(HyperGraph hg2) {
        this.hg = hg2;
    }

    @Override
    public Object make(HGPersistentHandle handle, LazyRef<HGHandle[]> targetSet, IncidenceSetRef incidenceSet) {
        ArrayType result = null;
        String className = new String(this.hg.getStore().getData(handle));
        try {
            Class<?> clazz = Class.forName(className);
            result = new ArrayType(clazz);
        }
        catch (Throwable t) {
            throw new HGException(t);
        }
        return result;
    }

    @Override
    public HGPersistentHandle store(Object instance) {
        ArrayType type = (ArrayType)instance;
        String className = type.getType().getName();
        HGPersistentHandle result = this.hg.getStore().store(className.getBytes());
        return result;
    }

    @Override
    public void release(HGPersistentHandle handle) {
        this.hg.getStore().removeData(handle);
    }

    @Override
    public boolean subsumes(Object general, Object specific) {
        return false;
    }
}

