/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.type;

import java.util.ArrayList;
import java.util.Iterator;
import org.hypergraphdb.HGException;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.IncidenceSetRef;
import org.hypergraphdb.LazyRef;
import org.hypergraphdb.type.HGAbstractCompositeType;
import org.hypergraphdb.type.HGAbstractType;
import org.hypergraphdb.type.HGAtomType;
import org.hypergraphdb.type.HGCompositeType;

public class AbstractTypeConstructor
implements HGAtomType {
    private HyperGraph graph;

    @Override
    public void setHyperGraph(HyperGraph hg2) {
        this.graph = hg2;
    }

    @Override
    public Object make(HGPersistentHandle handle, LazyRef<HGHandle[]> targetSet, IncidenceSetRef incidenceSet) {
        if (targetSet != null && targetSet.deref().length > 0) {
            throw new HGException("A HGAbstractType cannot be a link, attempt to create an atom instance with a non-empty target set.");
        }
        HGPersistentHandle[] layout = this.graph.getStore().getLink(handle);
        if (layout.length == 1) {
            return new HGAbstractType();
        }
        HGAbstractCompositeType type = new HGAbstractCompositeType();
        Object stringType = this.graph.getTypeSystem().getAtomType(String.class);
        for (int i = 0; i < layout.length; i += 2) {
            String name = (String)stringType.make(layout[i], null, null);
            HGHandle typeHandle = this.graph.refreshHandle(layout[i + 1]);
            type.addProjection(new HGAbstractCompositeType.Projection(name, typeHandle));
        }
        return type;
    }

    @Override
    public HGPersistentHandle store(Object instance) {
        if (!(instance instanceof HGAbstractType)) {
            throw new HGException("Attempt to store an abstract type, which is not an instance of HGAbstractType");
        }
        HGPersistentHandle pHandle = this.graph.getHandleFactory().makeHandle();
        if (!(instance instanceof HGCompositeType)) {
            this.graph.getStore().store(pHandle, new HGPersistentHandle[]{this.graph.getHandleFactory().nullHandle()});
        } else {
            HGCompositeType composite = (HGCompositeType)instance;
            Object stringType = this.graph.getTypeSystem().getAtomType(String.class);
            ArrayList<HGPersistentHandle> layout = new ArrayList<HGPersistentHandle>();
            Iterator<String> i = composite.getDimensionNames();
            while (i.hasNext()) {
                String name = i.next();
                layout.add(stringType.store(name));
                layout.add(this.graph.getPersistentHandle(this.graph.getPersistentHandle(composite.getProjection(name).getType())));
            }
            this.graph.getStore().store(pHandle, layout.toArray(new HGPersistentHandle[layout.size()]));
        }
        return pHandle;
    }

    @Override
    public void release(HGPersistentHandle handle) {
        this.graph.getStore().removeLink(handle);
    }

    @Override
    public boolean subsumes(Object general, Object specific) {
        return false;
    }
}

