/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.transaction;

import org.hypergraphdb.transaction.HGTransaction;
import org.hypergraphdb.transaction.HGTransactionManager;
import org.hypergraphdb.transaction.VBoxBody;

public class VBox<E> {
    protected HGTransactionManager txManager;
    volatile VBoxBody<E> body = this.makeNewBody(null, 0L, null);

    protected VBox() {
    }

    public VBox(HGTransactionManager txManager) {
        this(txManager, null);
    }

    public VBox(HGTransactionManager txManager, E initial) {
        this.txManager = txManager;
        this.commit(null, initial, 0L);
    }

    public E get() {
        HGTransaction tx = this.txManager.getContext().getCurrent();
        return (E)(tx == null ? this.body.value : tx.getBoxValue(this));
    }

    public void put(E newE) {
        HGTransaction tx = this.txManager.getContext().getCurrent();
        if (tx == null) {
            this.txManager.COMMIT_LOCK.lock();
            this.commit(tx, newE, this.txManager.mostRecentRecord.transactionNumber);
            this.txManager.COMMIT_LOCK.unlock();
        } else {
            tx.setBoxValue(this, newE);
        }
    }

    public VBoxBody<E> commit(HGTransaction tx, E newValue, long txNumber) {
        VBoxBody<E> newBody = this.makeNewBody(newValue, txNumber, this.body);
        this.body = newBody;
        return newBody;
    }

    public VBoxBody<E> makeNewBody(E value, long version, VBoxBody<E> next) {
        return new VBoxBody<E>(value, version, next);
    }

    public void finish(HGTransaction tx) {
    }
}

