/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.transaction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import org.hypergraphdb.HGException;
import org.hypergraphdb.HGRandomAccessResult;
import org.hypergraphdb.transaction.HGTransaction;
import org.hypergraphdb.transaction.HGTransactionManager;
import org.hypergraphdb.transaction.VBox;
import org.hypergraphdb.transaction.VBoxBody;
import org.hypergraphdb.util.CloneMe;
import org.hypergraphdb.util.HGSortedSet;

public class TxSet<E>
implements HGSortedSet<E> {
    private static final int ADD = 0;
    private static final int REMOVE = 1;
    private static final int CLEAR = 2;
    private static final int ADDALL = 3;
    private static final int REMOVEALL = 4;
    private static final int RETAINALL = 5;
    HGTransactionManager txManager;
    SetTxBox<E> S;

    void log(int op, Object el) {
        LogEntry entry = new LogEntry();
        entry.op = op;
        entry.el = el;
        ArrayList<LogEntry> log = (ArrayList<LogEntry>)this.txManager.getContext().getCurrent().getAttribute(this.S);
        if (log == null) {
            log = new ArrayList<LogEntry>();
            this.txManager.getContext().getCurrent().setAttribute(this.S, log);
        }
        log.add(entry);
    }

    void applyLog(List<LogEntry> log, HGSortedSet<E> set) {
        for (LogEntry e : log) {
            switch (e.op) {
                case 0: {
                    set.add(e.el);
                    break;
                }
                case 1: {
                    set.remove(e.el);
                    break;
                }
                case 2: {
                    set.clear();
                    break;
                }
                case 3: {
                    set.addAll((Collection)e.el);
                    break;
                }
                case 4: {
                    set.removeAll((Collection)e.el);
                    break;
                }
                case 5: {
                    set.retainAll((Collection)e.el);
                }
            }
        }
    }

    HGSortedSet<E> cloneSet(HGSortedSet<E> S) {
        if (S instanceof CloneMe) {
            return (HGSortedSet)((CloneMe)((Object)S)).clone();
        }
        try {
            HGSortedSet S2 = (HGSortedSet)S.getClass().newInstance();
            S2.addAll(S);
            return S2;
        }
        catch (Exception ex) {
            throw new HGException(ex);
        }
    }

    HGSortedSet<E> read() {
        return (HGSortedSet)this.S.get();
    }

    HGSortedSet<E> write() {
        List log = (List)this.txManager.getContext().getCurrent().getAttribute(this.S);
        if (log == null) {
            HGSortedSet readOnly = (HGSortedSet)this.S.get();
            HGSortedSet<E> writeable = this.cloneSet(readOnly);
            this.S.put(writeable);
        }
        return (HGSortedSet)this.S.get();
    }

    protected TxSet() {
    }

    public TxSet(HGTransactionManager txManager, HGSortedSet<E> backingSet) {
        this.txManager = txManager;
        this.S = new SetTxBox<E>(txManager, backingSet, this);
    }

    @Override
    public HGRandomAccessResult<E> getSearchResult() {
        return this.read().getSearchResult();
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.read().comparator();
    }

    @Override
    public E first() {
        return this.read().first();
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        return this.read().headSet(toElement);
    }

    @Override
    public E last() {
        return this.read().last();
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        return this.read().subSet(fromElement, toElement);
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        return this.read().tailSet(fromElement);
    }

    @Override
    public boolean add(E e) {
        boolean b = this.write().add(e);
        if (b) {
            this.log(0, e);
        }
        return b;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean b = this.write().addAll(c);
        if (b) {
            this.log(3, c);
        }
        return b;
    }

    @Override
    public void clear() {
        this.write().clear();
        this.log(2, null);
    }

    @Override
    public boolean contains(Object o) {
        return this.read().contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.read().containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.read().isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.read().iterator();
    }

    @Override
    public boolean remove(Object o) {
        boolean b = this.write().remove(o);
        if (b) {
            this.log(1, o);
        }
        return b;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean b = this.write().removeAll(c);
        if (b) {
            this.log(4, c);
        }
        return b;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean b = this.write().retainAll(c);
        if (b) {
            this.log(5, c);
        }
        return b;
    }

    @Override
    public int size() {
        return this.read().size();
    }

    @Override
    public Object[] toArray() {
        return this.read().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.read().toArray(a);
    }

    public static class SetTxBox<E>
    extends VBox<HGSortedSet<E>> {
        TxSet<E> thisSet;

        SetTxBox(HGTransactionManager txManager, HGSortedSet<E> backingSet, TxSet<E> thisSet) {
            super(txManager, backingSet);
            this.thisSet = thisSet;
        }

        HGSortedSet<E> getLastCommitted(HGTransaction tx) {
            return (HGSortedSet)this.body.getBody((long)tx.getNumber()).value;
        }

        @Override
        public VBoxBody<HGSortedSet<E>> commit(HGTransaction tx, HGSortedSet<E> newvalue, long txNumber) {
            if (tx != null) {
                HGSortedSet<E> lastCommitted = this.getLastCommitted(tx);
                List log = (List)tx.getAttribute(this);
                if (log != null) {
                    lastCommitted = this.thisSet.cloneSet(lastCommitted);
                    this.thisSet.applyLog(log, lastCommitted);
                    return super.commit(tx, lastCommitted, txNumber);
                }
                return this.body;
            }
            return super.commit(tx, newvalue, txNumber);
        }
    }

    static class LogEntry {
        int op;
        Object el;

        LogEntry() {
        }
    }
}

