/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.transaction;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.hypergraphdb.transaction.HGTransactionManager;
import org.hypergraphdb.transaction.VBox;

public class TxList<E>
implements List<E> {
    HGTransactionManager txManager = null;
    private VBox<Integer> sizebox = null;
    private VBox<Node<E>> head = null;
    private VBox<Node<E>> tail = null;

    Node<E> findNode(int index) {
        if (index < 0 || index >= this.sizebox.get()) {
            throw new IndexOutOfBoundsException("In TxList: " + index);
        }
        VBox<Node<E>> result = this.head;
        while (index-- > 0) {
            result = result.get().next;
        }
        return result.get();
    }

    public TxList(HGTransactionManager txManager) {
        this.txManager = txManager;
        this.sizebox = new VBox(txManager);
        this.sizebox.put(0);
        this.head = new VBox<Object>(txManager, null);
        this.tail = new VBox<Object>(txManager, null);
    }

    @Override
    public boolean add(E e) {
        Node<E> node = new Node<E>(e, new VBox<Object>(this.txManager, null));
        if (this.isEmpty()) {
            this.head.put(node);
        } else {
            this.tail.get().next.put(node);
        }
        this.tail.put(node);
        this.sizebox.put(this.sizebox.get() + 1);
        return true;
    }

    @Override
    public void add(int index, E e) {
        Node<E> node = new Node<E>(e, new VBox<Object>(this.txManager, null));
        if (index == 0) {
            if (this.isEmpty()) {
                this.tail.put(node);
            }
            node.next.put(this.head.get());
            this.head.put(node);
        } else {
            Node<E> prev = this.findNode(index - 1);
            node.next.put(prev.next.get());
            prev.next.put(node);
        }
        this.sizebox.put(this.sizebox.get() + 1);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        for (E x : c) {
            this.add(x);
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        Node<E> prev = null;
        if (index > 0) {
            prev = this.findNode(index - 1);
        }
        for (E e : c) {
            Node<E> node = new Node<E>(e, new VBox<Object>(this.txManager, null));
            if (prev == null) {
                node.next.put(this.head.get());
                this.head.put(node);
            } else {
                node.next.put(prev.next.get());
                prev.next.put(node);
            }
            if (this.tail.get() == prev) {
                this.tail.put(node);
            }
            prev = node;
        }
        this.sizebox.put(this.sizebox.get() + c.size());
        return true;
    }

    @Override
    public void clear() {
        this.head.put(null);
        this.tail.put(null);
        this.sizebox.put(0);
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object x : c) {
            if (this.contains(x)) continue;
            return false;
        }
        return true;
    }

    @Override
    public E get(int index) {
        Node<E> x = this.findNode(index);
        return x.value;
    }

    @Override
    public int indexOf(Object o) {
        int i = 0;
        Node<E> current = this.head.get();
        while (current != null) {
            if (current.value == o || o != null && o.equals(current.value)) {
                return i;
            }
            ++i;
            current = current.next.get();
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.sizebox.get() == 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private Node<E> next;
            {
                this.next = (Node)TxList.this.head.get();
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public E next() {
                Object x = this.next.value;
                this.next = this.next.next.get();
                return x;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int lastIndexOf(Object o) {
        int last = -1;
        int curr = 0;
        Node<E> current = this.head.get();
        while (current != null) {
            if (current.value == o || o != null && o.equals(current.value)) {
                last = curr;
            }
            ++curr;
            current = current.next.get();
        }
        return last;
    }

    @Override
    public ListIterator<E> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E remove(int index) {
        Object old;
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("In TxList: " + index);
        }
        if (index == 0) {
            old = this.head.get().value;
            this.head.put(this.head.get().next.get());
            if (this.sizebox.get() == 1) {
                this.tail.put(null);
            }
        } else {
            Node<E> prev = this.findNode(index - 1);
            if (this.tail.get() == prev.next.get()) {
                this.tail.put(prev);
            }
            old = prev.next.get().value;
            prev.next.put(prev.next.get().next.get());
        }
        this.sizebox.put(this.sizebox.get() - 1);
        return old;
    }

    @Override
    public boolean remove(Object o) {
        boolean found = false;
        Node<E> prev = null;
        Node<E> current = this.head.get();
        while (current != null) {
            if (!(current.value == o || o != null && o.equals(current.value))) {
                prev = current;
            } else {
                found = true;
                if (this.tail.get() == current) {
                    this.tail.put(prev);
                }
                if (prev == null) {
                    this.head.put(this.head.get().next.get());
                } else {
                    prev.next.put(current.next.get());
                }
            }
            current = current.next.get();
        }
        this.sizebox.put(this.sizebox.get() - 1);
        return found;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object x : c) {
            if (!this.remove(x)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E set(int index, E element) {
        Node<E> node = this.findNode(index);
        Object old = node.value;
        node.value = element;
        return old;
    }

    @Override
    public int size() {
        return this.sizebox.get();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        Object[] A = new Object[this.size()];
        int i = 0;
        for (E x : this) {
            A[i++] = x;
        }
        return A;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Class<?> type = a.getClass();
        Object[] copy = type == Object[].class ? new Object[this.size()] : (Object[])Array.newInstance(type.getComponentType(), this.size());
        int i = 0;
        for (Object x : this) {
            copy[i++] = x;
        }
        return copy;
    }

    private static class Node<E> {
        E value;
        VBox<Node<E>> next = null;

        public Node(E value, VBox<Node<E>> next) {
            this.value = value;
            this.next = next;
        }
    }
}

