/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.transaction;

import com.sleepycat.db.Cursor;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.Environment;
import com.sleepycat.db.Transaction;
import java.util.HashSet;
import java.util.Set;
import org.hypergraphdb.transaction.BDBTxCursor;
import org.hypergraphdb.transaction.HGStorageTransaction;
import org.hypergraphdb.transaction.HGTransactionException;

public class TransactionBDBImpl
implements HGStorageTransaction {
    private Environment env;
    private Transaction t;
    private Set<BDBTxCursor> bdbCursors = new HashSet<BDBTxCursor>();
    private boolean aborting = false;

    public static final TransactionBDBImpl nullTransaction() {
        return new TransactionBDBImpl(null, null);
    }

    public TransactionBDBImpl(Transaction t, Environment env) {
        this.t = t;
        this.env = env;
    }

    public Environment getBDBEnvironment() {
        return this.env;
    }

    public Transaction getBDBTransaction() {
        return this.t;
    }

    @Override
    public void commit() throws HGTransactionException {
        try {
            for (BDBTxCursor c : this.bdbCursors) {
                c.close();
            }
            if (this.t != null) {
                this.t.commit();
            }
        }
        catch (DatabaseException ex) {
            throw new HGTransactionException("Failed to commit transaction", ex);
        }
    }

    @Override
    public void abort() throws HGTransactionException {
        try {
            this.aborting = true;
            for (BDBTxCursor c : this.bdbCursors) {
                try {
                    c.close();
                }
                catch (Throwable t) {
                    System.err.println(t);
                }
            }
            if (this.t != null) {
                this.t.abort();
            }
        }
        catch (DatabaseException ex) {
            throw new HGTransactionException("Failed to abort transaction", ex);
        }
    }

    public BDBTxCursor attachCursor(Cursor cursor) {
        if (this.t == null) {
            return new BDBTxCursor(cursor, null);
        }
        BDBTxCursor c = new BDBTxCursor(cursor, this);
        this.bdbCursors.add(c);
        return c;
    }

    void removeCursor(BDBTxCursor c) {
        if (!this.aborting) {
            this.bdbCursors.remove(c);
        }
    }
}

