/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.transaction;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.event.HGTransactionEndEvent;
import org.hypergraphdb.transaction.ActiveTransactionsRecord;
import org.hypergraphdb.transaction.HGStorageTransaction;
import org.hypergraphdb.transaction.HGTransactionContext;
import org.hypergraphdb.transaction.HGTransactionException;
import org.hypergraphdb.transaction.TransactionConflictException;
import org.hypergraphdb.transaction.VBox;
import org.hypergraphdb.transaction.VBoxBody;
import org.hypergraphdb.util.Cons;

public final class HGTransaction
implements HGStorageTransaction {
    static final Object NULL_VALUE = new Object();
    private HGTransaction parent;
    private HGTransactionContext context;
    private HGStorageTransaction stran = null;
    private Map<Object, Object> attributes = new HashMap<Object, Object>();
    Map<VBox<?>, VBoxBody<?>> bodiesRead = new HashMap();
    private Map<VBox<?>, Object> boxesWritten = new HashMap();
    private long number;
    private boolean readonly = false;
    private ActiveTransactionsRecord activeTxRecord;

    long getNumber() {
        return this.number;
    }

    <T> T getLocalValue(VBox<T> vbox) {
        Object value = null;
        HGTransaction tx = this;
        while ((value = tx.boxesWritten.get(vbox)) == null && (tx = tx.parent) != null) {
        }
        return (T)value;
    }

    <T> T getBoxValue(VBox<T> vbox) {
        Object value = this.getLocalValue(vbox);
        if (value == null) {
            VBoxBody body = vbox.body.getBody(this.number);
            if (!this.readonly) {
                this.bodiesRead.put(vbox, body);
            }
            value = body.value;
        }
        return value == NULL_VALUE ? null : (T)value;
    }

    <T> void setBoxValue(VBox<T> vbox, T value) {
        this.boxesWritten.put(vbox, value == null ? NULL_VALUE : value);
    }

    private boolean isWriteTransaction() {
        return !this.boxesWritten.isEmpty();
    }

    protected boolean validateCommit() {
        if (!this.readonly) {
            for (Map.Entry<VBox<?>, VBoxBody<?>> entry : this.bodiesRead.entrySet()) {
                if (entry.getKey().body.version == entry.getValue().version) continue;
                return false;
            }
        }
        return true;
    }

    protected Cons<VBoxBody<?>> performValidCommit() {
        this.number = this.context.getManager().mostRecentRecord.transactionNumber + 1L;
        return this.doCommit();
    }

    protected Cons<VBoxBody<?>> doCommit() {
        Cons<VBoxBody<Object>> newBodies = Cons.EMPTY;
        for (Map.Entry<VBox<?>, Object> entry : this.boxesWritten.entrySet()) {
            VBox<?> vbox = entry.getKey();
            Object newValue = entry.getValue();
            VBoxBody<Object> newBody = vbox.commit(this, newValue == NULL_VALUE ? null : newValue, this.number);
            newBodies = newBodies.cons(newBody);
        }
        return newBodies;
    }

    void finish() {
        if (!this.readonly) {
            for (Map.Entry<VBox<?>, Object> entry : this.bodiesRead.entrySet()) {
                entry.getKey().finish(this);
            }
        }
        for (Map.Entry<VBox<?>, Object> entry : this.boxesWritten.entrySet()) {
            entry.getKey().finish(this);
        }
        this.bodiesRead = null;
        this.boxesWritten = null;
        this.activeTxRecord.decrementRunning();
    }

    private void fatalFailure(Throwable t) {
        this.context.getManager().setEnabled(false);
        this.context.getManager().mostRecentRecord = null;
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw (RuntimeException)t;
    }

    HGTransaction(HGTransactionContext context, HGTransaction parent, ActiveTransactionsRecord activeTxRecord, HGStorageTransaction impl, boolean readonly) {
        this.stran = impl;
        this.context = context;
        this.parent = parent;
        this.activeTxRecord = activeTxRecord;
        this.number = activeTxRecord.transactionNumber;
        this.readonly = readonly;
    }

    public HGStorageTransaction getStorageTransaction() {
        return this.stran;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws HGTransactionException {
        assert (!this.isReadOnly() || !this.isWriteTransaction()) : "Transaction configured as read-only was used to modify data!";
        if (this.parent != null) {
            if (this.stran != null) {
                this.stran.commit();
            }
            if (!this.readonly) {
                this.parent.bodiesRead.putAll(this.bodiesRead);
            }
            this.parent.boxesWritten.putAll(this.boxesWritten);
            this.finish();
            HyperGraph graph = this.context.getManager().getHyperGraph();
            graph.getEventManager().dispatch(graph, new HGTransactionEndEvent(this, true));
            return;
        }
        if (this.isWriteTransaction()) {
            this.context.getManager().COMMIT_LOCK.lock();
            try {
                if (this.validateCommit()) {
                    if (this.stran != null) {
                        this.stran.commit();
                    }
                    Cons<VBoxBody<?>> bodiesCommitted = this.performValidCommit();
                    ActiveTransactionsRecord newRecord = new ActiveTransactionsRecord(this.number, bodiesCommitted);
                    this.context.getManager().mostRecentRecord.setNext(newRecord);
                    this.context.getManager().mostRecentRecord = newRecord;
                    newRecord.incrementRunning();
                    this.activeTxRecord.decrementRunning();
                    this.activeTxRecord = newRecord;
                }
                try {
                    this.privateAbort();
                }
                catch (Throwable t) {
                    this.fatalFailure(t);
                }
                throw new TransactionConflictException();
            }
            catch (TransactionConflictException rethrowme) {
                throw rethrowme;
            }
            catch (Throwable t) {
                this.fatalFailure(t);
            }
            finally {
                this.context.getManager().COMMIT_LOCK.unlock();
            }
        } else if (this.stran != null) {
            this.stran.commit();
        }
        this.finish();
        HyperGraph graph = this.context.getManager().getHyperGraph();
        graph.getEventManager().dispatch(graph, new HGTransactionEndEvent(this, true));
    }

    private void privateAbort() throws HGTransactionException {
        if (this.stran != null) {
            this.stran.abort();
        }
        this.finish();
    }

    @Override
    public void abort() throws HGTransactionException {
        this.privateAbort();
        HyperGraph graph = this.context.getManager().getHyperGraph();
        graph.getEventManager().dispatch(graph, new HGTransactionEndEvent(this, false));
    }

    public <T> T getAttribute(Object key) {
        return (T)this.attributes.get(key);
    }

    public Iterator<Object> getAttributeKeys() {
        return this.attributes.keySet().iterator();
    }

    public void removeAttribute(Object key) {
        this.attributes.remove(key);
    }

    public void setAttribute(Object key, Object value) {
        this.attributes.put(key, value);
    }

    public boolean isReadOnly() {
        return this.readonly;
    }
}

