/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.transaction;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.hypergraphdb.transaction.VBoxBody;
import org.hypergraphdb.util.Cons;

public class ActiveTransactionsRecord {
    public final long transactionNumber;
    private final AtomicReference<Cons<VBoxBody<?>>> bodiesToGC;
    private final AtomicInteger running = new AtomicInteger(0);
    private volatile ActiveTransactionsRecord next = null;
    private volatile ActiveTransactionsRecord prev = null;

    public ActiveTransactionsRecord(long txNumber, Cons<VBoxBody<?>> bodiesToGC) {
        this.transactionNumber = txNumber;
        this.bodiesToGC = new AtomicReference(bodiesToGC);
    }

    public void incrementRunning() {
        this.running.incrementAndGet();
    }

    public ActiveTransactionsRecord getNext() {
        return this.next;
    }

    protected void setPrev(ActiveTransactionsRecord prev) {
        this.prev = prev;
    }

    protected void setNext(ActiveTransactionsRecord next) {
        this.next = next;
    }

    public ActiveTransactionsRecord getRecordForNewTransaction() {
        ActiveTransactionsRecord rec = this;
        while (true) {
            rec.running.incrementAndGet();
            if (rec.next == null) {
                return rec;
            }
            rec.decrementRunning();
            rec = rec.next;
        }
    }

    public void maybeUnchain() {
        if (this.prev != null && this.next != null && this.running.get() == 0) {
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.next = null;
            this.prev = null;
        }
    }

    public void decrementRunning() {
        if (this.running.decrementAndGet() == 0) {
            this.maybeCleanSuc();
            this.maybeUnchain();
        }
    }

    private void maybeCleanSuc() {
        ActiveTransactionsRecord rec = this;
        while (rec.next != null && rec.isClean() && rec.running.get() == 0 && rec.next.clean()) {
            rec = rec.next;
        }
    }

    private boolean isClean() {
        return this.bodiesToGC.get() == null;
    }

    protected boolean clean() {
        Cons toClean = this.bodiesToGC.getAndSet(null);
        if (toClean != null) {
            for (VBoxBody body : toClean) {
                body.clearPrevious();
            }
            return true;
        }
        return false;
    }
}

