/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.storage;

import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.LockMode;
import com.sleepycat.db.OperationStatus;
import com.sleepycat.db.SecondaryCursor;
import org.hypergraphdb.HGException;
import org.hypergraphdb.HGRandomAccessResult;
import org.hypergraphdb.storage.ByteArrayConverter;
import org.hypergraphdb.storage.IndexResultSet;
import org.hypergraphdb.transaction.BDBTxCursor;
import org.hypergraphdb.util.HGUtils;

public class SingleValueResultSet<T>
extends IndexResultSet<T> {
    private DatabaseEntry pkey = new DatabaseEntry();

    public SingleValueResultSet(BDBTxCursor cursor, DatabaseEntry keyIn, ByteArrayConverter<T> converter) {
        this.converter = converter;
        this.cursor = cursor;
        this.key = new DatabaseEntry();
        if (keyIn != null) {
            this.assignData(this.key, keyIn.getData());
        }
        try {
            ((SecondaryCursor)cursor.cursor()).getCurrent(this.key, this.pkey, this.data, LockMode.DEFAULT);
            this.next = converter.fromByteArray(this.pkey.getData());
            this.lookahead = 1;
        }
        catch (Throwable t) {
            throw new HGException(t);
        }
    }

    @Override
    protected T advance() {
        try {
            OperationStatus status = ((SecondaryCursor)this.cursor.cursor()).getNextDup(this.key, this.pkey, this.data, LockMode.DEFAULT);
            if (status == OperationStatus.SUCCESS) {
                return this.converter.fromByteArray(this.pkey.getData());
            }
            return null;
        }
        catch (Throwable t) {
            this.closeNoException();
            throw new HGException(t);
        }
    }

    @Override
    protected T back() {
        try {
            OperationStatus status = ((SecondaryCursor)this.cursor.cursor()).getPrevDup(this.key, this.pkey, this.data, LockMode.DEFAULT);
            if (status == OperationStatus.SUCCESS) {
                return this.converter.fromByteArray(this.pkey.getData());
            }
            return null;
        }
        catch (Throwable t) {
            this.closeNoException();
            throw new HGException(t);
        }
    }

    @Override
    public HGRandomAccessResult.GotoResult goTo(T value, boolean exactMatch) {
        byte[] B = this.converter.toByteArray(value);
        this.assignData(this.pkey, B);
        try {
            if (exactMatch) {
                if (((SecondaryCursor)this.cursor.cursor()).getSearchBoth(this.key, this.pkey, this.data, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                    this.positionToCurrent(this.pkey.getData());
                    return HGRandomAccessResult.GotoResult.found;
                }
                return HGRandomAccessResult.GotoResult.nothing;
            }
            if (((SecondaryCursor)this.cursor.cursor()).getSearchBothRange(this.key, this.pkey, this.data, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                this.positionToCurrent(this.pkey.getData());
                return HGUtils.eq(B, this.pkey.getData()) ? HGRandomAccessResult.GotoResult.found : HGRandomAccessResult.GotoResult.close;
            }
            return HGRandomAccessResult.GotoResult.nothing;
        }
        catch (Throwable t) {
            this.closeNoException();
            throw new HGException(t);
        }
    }

    @Override
    public boolean isOrdered() {
        return false;
    }
}

