/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.storage;

import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.LockMode;
import com.sleepycat.db.OperationStatus;
import org.hypergraphdb.HGException;
import org.hypergraphdb.storage.ByteArrayConverter;
import org.hypergraphdb.storage.IndexResultSet;
import org.hypergraphdb.transaction.BDBTxCursor;

public class SingleKeyResultSet<T>
extends IndexResultSet<T> {
    private boolean ordered = false;

    public SingleKeyResultSet(BDBTxCursor cursor, DatabaseEntry key, ByteArrayConverter<T> converter) {
        super(cursor, key, converter);
        try {
            this.ordered = cursor.cursor().getDatabase().getConfig().getSortedDuplicates();
        }
        catch (Throwable t) {
            throw new HGException(t);
        }
    }

    @Override
    protected T advance() {
        try {
            OperationStatus status = this.cursor.cursor().getNextDup(this.key, this.data, LockMode.DEFAULT);
            if (status == OperationStatus.SUCCESS) {
                return this.converter.fromByteArray(this.data.getData());
            }
            return null;
        }
        catch (Throwable t) {
            this.closeNoException();
            throw new HGException(t);
        }
    }

    @Override
    protected T back() {
        try {
            OperationStatus status = this.cursor.cursor().getPrevDup(this.key, this.data, LockMode.DEFAULT);
            if (status == OperationStatus.SUCCESS) {
                return this.converter.fromByteArray(this.data.getData());
            }
            return null;
        }
        catch (Throwable t) {
            this.closeNoException();
            throw new HGException(t);
        }
    }

    @Override
    public boolean isOrdered() {
        return this.ordered;
    }
}

