/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.storage;

import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import org.hypergraphdb.HGException;
import org.hypergraphdb.HGHandleFactory;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.HyperGraph;

public class LinkBinding
extends TupleBinding<HGPersistentHandle[]> {
    private HGHandleFactory handleFactory;
    private int handleSize;

    public LinkBinding(HGHandleFactory handleFactory) {
        this.handleFactory = handleFactory;
        this.handleSize = handleFactory.nullHandle().toByteArray().length;
    }

    public HGPersistentHandle[] readHandles(byte[] buffer, int offset, int length) {
        if (length == 0) {
            return HyperGraph.EMPTY_PERSISTENT_HANDLE_SET;
        }
        int handle_count = length / this.handleSize;
        HGPersistentHandle[] handles = new HGPersistentHandle[handle_count];
        for (int i = 0; i < handle_count; ++i) {
            handles[i] = this.handleFactory.makeHandle(buffer, offset + i * this.handleSize);
        }
        return handles;
    }

    public HGPersistentHandle[] entryToObject(TupleInput input) {
        int size = input.getBufferLength() - input.getBufferOffset();
        if (size % this.handleSize != 0) {
            throw new HGException("While reading link tuple: the value buffer size is not a multiple of the handle size.");
        }
        return this.readHandles(input.getBufferBytes(), 0, size);
    }

    public void objectToEntry(HGPersistentHandle[] link, TupleOutput output) {
        byte[] buffer = new byte[link.length * this.handleSize];
        for (int i = 0; i < link.length; ++i) {
            HGPersistentHandle handle = link[i];
            System.arraycopy(handle.toByteArray(), 0, buffer, i * this.handleSize, this.handleSize);
        }
        output.writeFast(buffer);
    }
}

