/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.storage;

import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.LockMode;
import com.sleepycat.db.OperationStatus;
import org.hypergraphdb.HGException;
import org.hypergraphdb.storage.ByteArrayConverter;
import org.hypergraphdb.storage.IndexResultSet;
import org.hypergraphdb.transaction.BDBTxCursor;
import org.hypergraphdb.util.HGUtils;

class KeyRangeForwardResultSet<T>
extends IndexResultSet<T> {
    private DatabaseEntry initialKey = new DatabaseEntry();

    @Override
    protected T advance() {
        try {
            OperationStatus status = this.cursor.cursor().getNext(this.key, this.data, LockMode.DEFAULT);
            if (status == OperationStatus.SUCCESS) {
                return this.converter.fromByteArray(this.data.getData());
            }
            return null;
        }
        catch (Throwable t) {
            this.closeNoException();
            throw new HGException(t);
        }
    }

    @Override
    protected T back() {
        if (HGUtils.eq(this.key.getData(), this.initialKey.getData())) {
            return null;
        }
        try {
            OperationStatus status = this.cursor.cursor().getPrev(this.key, this.data, LockMode.DEFAULT);
            if (status == OperationStatus.SUCCESS) {
                return this.converter.fromByteArray(this.data.getData());
            }
            return null;
        }
        catch (Throwable t) {
            this.closeNoException();
            throw new HGException(t);
        }
    }

    public KeyRangeForwardResultSet(BDBTxCursor cursor, DatabaseEntry key, ByteArrayConverter<T> converter) {
        super(cursor, key, converter);
        this.assignData(this.initialKey, key.getData());
    }

    @Override
    public boolean isOrdered() {
        return true;
    }
}

