/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.storage;

import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.LockMode;
import com.sleepycat.db.OperationStatus;
import java.util.NoSuchElementException;
import org.hypergraphdb.HGException;
import org.hypergraphdb.HGRandomAccessResult;
import org.hypergraphdb.storage.ByteArrayConverter;
import org.hypergraphdb.transaction.BDBTxCursor;
import org.hypergraphdb.util.HGUtils;

public abstract class IndexResultSet<T>
implements HGRandomAccessResult<T> {
    private static final Object UNKNOWN = new Object();
    protected BDBTxCursor cursor;
    protected Object current = UNKNOWN;
    protected Object prev = UNKNOWN;
    protected Object next = UNKNOWN;
    protected DatabaseEntry key;
    protected DatabaseEntry data = new DatabaseEntry();
    protected ByteArrayConverter<T> converter;
    protected int lookahead = 0;

    protected final void closeNoException() {
        try {
            this.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected final void checkCursor() {
        if (!this.cursor.isOpen()) {
            throw new HGException("DefaultIndexImpl.IndexResultSet: attempt to perform an operation on a closed or invalid cursor.");
        }
    }

    protected void assignData(DatabaseEntry entry, byte[] data) {
        byte[] dest = entry.getData();
        if (dest == null || dest.length != data.length) {
            dest = new byte[data.length];
            entry.setData(dest);
        }
        System.arraycopy(data, 0, dest, 0, data.length);
    }

    protected final void moveNext() {
        this.prev = this.current;
        this.current = this.next;
        this.next = UNKNOWN;
        --this.lookahead;
    }

    protected final void movePrev() {
        this.next = this.current;
        this.current = this.prev;
        this.prev = UNKNOWN;
        ++this.lookahead;
    }

    protected abstract T advance();

    protected abstract T back();

    protected IndexResultSet() {
    }

    public IndexResultSet(BDBTxCursor cursor, DatabaseEntry keyIn, ByteArrayConverter<T> converter) {
        this.converter = converter;
        this.cursor = cursor;
        this.key = new DatabaseEntry();
        if (keyIn != null) {
            this.assignData(this.key, keyIn.getData());
        }
        try {
            cursor.cursor().getCurrent(this.key, this.data, LockMode.DEFAULT);
            this.next = converter.fromByteArray(this.data.getData());
            this.lookahead = 1;
        }
        catch (Throwable t) {
            throw new HGException(t);
        }
    }

    protected void positionToCurrent(byte[] data) {
        this.current = this.converter.fromByteArray(data);
        this.lookahead = 0;
        this.prev = this.next = UNKNOWN;
    }

    @Override
    public void goBeforeFirst() {
        try {
            if (this.cursor.cursor().getFirst(this.key, this.data, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                this.current = UNKNOWN;
                this.prev = null;
                this.next = this.converter.fromByteArray(this.data.getData());
                this.lookahead = 1;
            } else {
                this.next = null;
                this.prev = null;
                this.current = UNKNOWN;
                this.lookahead = 0;
            }
        }
        catch (Throwable t) {
            this.closeNoException();
            throw new HGException(t);
        }
    }

    @Override
    public void goAfterLast() {
        try {
            if (this.cursor.cursor().getLast(this.key, this.data, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                this.current = UNKNOWN;
                this.next = null;
                this.prev = this.converter.fromByteArray(this.data.getData());
                this.lookahead = -1;
            } else {
                this.next = null;
                this.prev = null;
                this.current = UNKNOWN;
                this.lookahead = 0;
            }
        }
        catch (Throwable t) {
            this.closeNoException();
            throw new HGException(t);
        }
    }

    @Override
    public HGRandomAccessResult.GotoResult goTo(T value, boolean exactMatch) {
        byte[] B = this.converter.toByteArray(value);
        this.assignData(this.data, B);
        try {
            OperationStatus status = null;
            if (exactMatch) {
                status = this.cursor.cursor().getSearchBoth(this.key, this.data, LockMode.DEFAULT);
                if (status == OperationStatus.SUCCESS) {
                    this.positionToCurrent(this.data.getData());
                    return HGRandomAccessResult.GotoResult.found;
                }
                return HGRandomAccessResult.GotoResult.nothing;
            }
            status = this.cursor.cursor().getSearchBothRange(this.key, this.data, LockMode.DEFAULT);
            if (status == OperationStatus.SUCCESS) {
                HGRandomAccessResult.GotoResult result = HGUtils.eq(B, this.data.getData()) ? HGRandomAccessResult.GotoResult.found : HGRandomAccessResult.GotoResult.close;
                this.positionToCurrent(this.data.getData());
                return result;
            }
            return HGRandomAccessResult.GotoResult.nothing;
        }
        catch (Throwable t) {
            this.closeNoException();
            throw new HGException(t);
        }
    }

    @Override
    public final void close() {
        if (this.cursor == null) {
            return;
        }
        try {
            this.next = this.prev = UNKNOWN;
            this.current = this.prev;
            this.key = null;
            this.cursor.close();
        }
        catch (Throwable t) {
            throw new HGException("Exception while closing a DefaultIndexImpl cursor: " + t.toString(), t);
        }
        finally {
            this.cursor = null;
        }
    }

    @Override
    public final T current() {
        if (this.current == UNKNOWN) {
            throw new NoSuchElementException();
        }
        return (T)this.current;
    }

    @Override
    public final boolean hasPrev() {
        if (this.prev == UNKNOWN) {
            while (this.lookahead > -1) {
                this.prev = this.back();
                if (this.prev == null) break;
                --this.lookahead;
            }
        }
        return this.prev != null;
    }

    @Override
    public final boolean hasNext() {
        if (this.next == UNKNOWN) {
            while (this.lookahead < 1) {
                this.next = this.advance();
                if (this.next == null) break;
                ++this.lookahead;
            }
        }
        return this.next != null;
    }

    @Override
    public final T prev() {
        if (!this.hasPrev()) {
            throw new NoSuchElementException();
        }
        this.movePrev();
        return this.current();
    }

    @Override
    public final T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.moveNext();
        return this.current();
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException("HG - IndexResultSet does not implement remove.");
    }

    protected void finalize() {
        this.closeNoException();
    }

    public int count() {
        try {
            return this.cursor.cursor().count();
        }
        catch (DatabaseException ex) {
            throw new HGException(ex);
        }
    }

    public void removeCurrent() {
        try {
            this.cursor.cursor().delete();
        }
        catch (DatabaseException ex) {
            throw new HGException(ex);
        }
    }
}

