/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.storage;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.HGStore;
import org.hypergraphdb.storage.StorageGraph;
import org.hypergraphdb.util.Pair;

public class HGStoreSubgraph
implements StorageGraph {
    private Set<HGPersistentHandle> roots;
    private HGStore store;

    public HGStoreSubgraph(HGPersistentHandle root, HGStore store) {
        this.roots = new HashSet<HGPersistentHandle>();
        this.roots.add(root);
        this.store = store;
    }

    public HGStoreSubgraph(Set<HGPersistentHandle> roots, HGStore store) {
        this.roots = roots;
        this.store = store;
    }

    @Override
    public byte[] getData(HGPersistentHandle handle) {
        return this.store.getData(handle);
    }

    @Override
    public HGPersistentHandle[] getLink(HGPersistentHandle handle) {
        return this.store.getLink(handle);
    }

    @Override
    public Set<HGPersistentHandle> getRoots() {
        return this.roots;
    }

    @Override
    public Iterator<Pair<HGPersistentHandle, Object>> iterator() {
        return new SubgraphIterator();
    }

    private class SubgraphIterator
    implements Iterator<Pair<HGPersistentHandle, Object>> {
        LinkedList<HGPersistentHandle> remaining = new LinkedList();
        HashSet<HGPersistentHandle> visited = new HashSet();

        public SubgraphIterator() {
            for (HGPersistentHandle root : HGStoreSubgraph.this.roots) {
                this.remaining.addLast(root);
            }
            this.visited.add(HGStoreSubgraph.this.store.getTransactionManager().getHyperGraph().getHandleFactory().nullHandle());
        }

        @Override
        public boolean hasNext() {
            return !this.remaining.isEmpty();
        }

        @Override
        public Pair<HGPersistentHandle, Object> next() {
            Pair<HGPersistentHandle, Object[]> result = null;
            HGPersistentHandle h = this.remaining.removeFirst();
            HGPersistentHandle[] link = HGStoreSubgraph.this.store.getLink(h);
            if (link == null) {
                byte[] data = HGStoreSubgraph.this.store.getData(h);
                if (data != null) {
                    this.visited.add(h);
                    result = new Pair<HGPersistentHandle, byte[]>(h, data);
                }
            } else {
                this.visited.add(h);
                for (HGPersistentHandle x : link) {
                    if (this.visited.contains(x)) continue;
                    this.remaining.addLast(x);
                }
                result = new Pair<HGPersistentHandle, HGPersistentHandle[]>(h, link);
            }
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

