/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.storage;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import org.hypergraphdb.HGIndex;
import org.hypergraphdb.HGRandomAccessResult;
import org.hypergraphdb.util.HGSortedSet;

public class DBKeyedSortedSet<Key, T>
implements HGSortedSet<T> {
    private Key key;
    private Comparator<T> comparator = null;
    private HGIndex<Key, T> index = null;

    static <E> Comparator<E> makeComparator() {
        return new Comparator<E>(){

            @Override
            public int compare(E x, E y) {
                return ((Comparable)x).compareTo(y);
            }
        };
    }

    public DBKeyedSortedSet(HGIndex<Key, T> idx, Key key) {
        this.index = idx;
        this.key = key;
        this.comparator = DBKeyedSortedSet.makeComparator();
    }

    public DBKeyedSortedSet(HGIndex<Key, T> idx, Key key, Comparator<T> comparator) {
        this.index = idx;
        this.key = key;
        this.comparator = comparator;
    }

    @Override
    public HGRandomAccessResult<T> getSearchResult() {
        return this.index.find(this.key);
    }

    @Override
    public Comparator<T> comparator() {
        return this.comparator;
    }

    @Override
    public T first() {
        return this.index.findFirst(this.key);
    }

    @Override
    public SortedSet<T> headSet(T toElement) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T last() {
        throw new UnsupportedOperationException("No easy BerkeleyDB method for this one, need to iterate until the end - unefficient.");
    }

    @Override
    public SortedSet<T> subSet(T fromElement, T toElement) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SortedSet<T> tailSet(T fromElement) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(T o) {
        if (this.contains(o)) {
            return false;
        }
        this.index.addEntry(this.key, o);
        return true;
    }

    @Override
    public boolean addAll(Collection c) {
        boolean modified = false;
        for (Object x : c) {
            modified = modified || this.add((T)x);
        }
        return modified;
    }

    @Override
    public void clear() {
        this.index.removeAllEntries(this.key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        HGRandomAccessResult<T> rs = this.getSearchResult();
        try {
            boolean bl = rs.goTo(o, true) == HGRandomAccessResult.GotoResult.found;
            return bl;
        }
        finally {
            rs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection c) {
        HGRandomAccessResult<T> rs = this.getSearchResult();
        try {
            for (Object x : c) {
                if (rs.goTo(x, true) == HGRandomAccessResult.GotoResult.found) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            rs.close();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.first() == null;
    }

    @Override
    public Iterator<T> iterator() {
        throw new UnsupportedOperationException("Use getSearchResult and make sure you close it.");
    }

    @Override
    public boolean remove(Object o) {
        if (this.contains(o)) {
            this.index.removeEntry(this.key, o);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection c) {
        boolean modified = false;
        for (Object x : c) {
            modified = modified || this.remove(x);
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return (int)this.index.count(this.key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        HGRandomAccessResult<T> rs = this.getSearchResult();
        try {
            int size = this.size();
            Object[] a = new Object[size];
            for (int i = 0; i < size; ++i) {
                a[i] = rs.next();
            }
            Object[] objectArray = a;
            return objectArray;
        }
        finally {
            rs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E> E[] toArray(E[] a) {
        HGRandomAccessResult<T> rs = this.getSearchResult();
        try {
            int size = this.size();
            if (a.length < size) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
            }
            for (int i = 0; i < size; ++i) {
                a[i] = rs.next();
            }
            if (a.length > size) {
                a[size] = null;
            }
            Object[] objectArray = a;
            return objectArray;
        }
        finally {
            rs.close();
        }
    }
}

