/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.storage;

import com.sleepycat.db.Cursor;
import com.sleepycat.db.CursorConfig;
import com.sleepycat.db.Database;
import com.sleepycat.db.DatabaseConfig;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.Environment;
import com.sleepycat.db.EnvironmentConfig;
import com.sleepycat.db.LockMode;
import com.sleepycat.db.OperationStatus;
import com.sleepycat.db.Transaction;
import com.sleepycat.db.TransactionConfig;
import java.io.File;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hypergraphdb.HGConfiguration;
import org.hypergraphdb.HGException;
import org.hypergraphdb.HGHandleFactory;
import org.hypergraphdb.HGIndex;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.HGRandomAccessResult;
import org.hypergraphdb.HGSearchResult;
import org.hypergraphdb.HGStore;
import org.hypergraphdb.storage.BAtoHandle;
import org.hypergraphdb.storage.BDBConfig;
import org.hypergraphdb.storage.ByteArrayConverter;
import org.hypergraphdb.storage.DefaultBiIndexImpl;
import org.hypergraphdb.storage.DefaultIndexImpl;
import org.hypergraphdb.storage.HGStoreImplementation;
import org.hypergraphdb.storage.LinkBinding;
import org.hypergraphdb.storage.SingleKeyResultSet;
import org.hypergraphdb.transaction.HGStorageTransaction;
import org.hypergraphdb.transaction.HGTransaction;
import org.hypergraphdb.transaction.HGTransactionConfig;
import org.hypergraphdb.transaction.HGTransactionContext;
import org.hypergraphdb.transaction.HGTransactionFactory;
import org.hypergraphdb.transaction.TransactionBDBImpl;
import org.hypergraphdb.transaction.VanillaTransaction;

public class BDBStorageImplementation
implements HGStoreImplementation {
    private static final String DATA_DB_NAME = "datadb";
    private static final String PRIMITIVE_DB_NAME = "primitivedb";
    private static final String INCIDENCE_DB_NAME = "incidencedb";
    private BDBConfig configuration;
    private HGStore store;
    private HGHandleFactory handleFactory;
    private CursorConfig cursorConfig = new CursorConfig();
    private Environment env = null;
    private Database data_db = null;
    private Database primitive_db = null;
    private Database incidence_db = null;
    private HashMap<String, HGIndex<?, ?>> openIndices = new HashMap();
    private ReentrantReadWriteLock indicesLock = new ReentrantReadWriteLock();
    private LinkBinding linkBinding = null;
    CheckPointThread checkPointThread = null;

    private TransactionBDBImpl txn() {
        HGTransaction tx = this.store.getTransactionManager().getContext().getCurrent();
        if (tx == null || tx.getStorageTransaction() instanceof VanillaTransaction) {
            return TransactionBDBImpl.nullTransaction();
        }
        return (TransactionBDBImpl)tx.getStorageTransaction();
    }

    public BDBStorageImplementation() {
        this.configuration = new BDBConfig();
    }

    @Override
    public BDBConfig getConfiguration() {
        return this.configuration;
    }

    public Environment getBerkleyEnvironment() {
        return this.env;
    }

    @Override
    public void startup(HGStore store, HGConfiguration config) {
        this.store = store;
        this.handleFactory = config.getHandleFactory();
        this.linkBinding = new LinkBinding(this.handleFactory);
        EnvironmentConfig envConfig = this.configuration.getEnvironmentConfig();
        if (config.isTransactional()) {
            this.configuration.configureTransactional();
        }
        File envDir = new File(store.getDatabaseLocation());
        envDir.mkdirs();
        try {
            this.env = new Environment(envDir, envConfig);
            this.data_db = this.env.openDatabase(null, DATA_DB_NAME, null, this.configuration.getDatabaseConfig().cloneConfig());
            this.primitive_db = this.env.openDatabase(null, PRIMITIVE_DB_NAME, null, this.configuration.getDatabaseConfig().cloneConfig());
            DatabaseConfig incConfig = this.configuration.getDatabaseConfig().cloneConfig();
            incConfig.setSortedDuplicates(true);
            this.incidence_db = this.env.openDatabase(null, INCIDENCE_DB_NAME, null, incConfig);
            if (config.isTransactional()) {
                this.checkPointThread = new CheckPointThread();
                this.checkPointThread.start();
            }
        }
        catch (Exception ex) {
            throw new HGException("Failed to initialize HyperGraph data store: " + ex.toString(), ex);
        }
    }

    @Override
    public void shutdown() {
        if (this.checkPointThread != null) {
            this.checkPointThread.stop = true;
            this.checkPointThread.interrupt();
            while (this.checkPointThread.running) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ex) {}
            }
        }
        if (this.env != null) {
            try {
                if (this.env.getConfig().getTransactional()) {
                    this.env.checkpoint(null);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            Iterator<HGIndex<?, ?>> i = this.openIndices.values().iterator();
            while (i.hasNext()) {
                try {
                    i.next().close();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            try {
                this.data_db.close();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            try {
                this.primitive_db.close();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            try {
                this.incidence_db.close();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            try {
                this.env.close();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    @Override
    public void removeLink(HGPersistentHandle handle) {
        if (handle == null) {
            throw new NullPointerException("HGStore.remove called with a null handle.");
        }
        try {
            DatabaseEntry key = new DatabaseEntry(handle.toByteArray());
            this.data_db.delete(this.txn().getBDBTransaction(), key);
        }
        catch (Exception ex) {
            throw new HGException("Failed to remove value with handle " + handle + ": " + ex.toString(), ex);
        }
    }

    @Override
    public void store(HGPersistentHandle handle, byte[] data) {
        try {
            OperationStatus result = this.primitive_db.put(this.txn().getBDBTransaction(), new DatabaseEntry(handle.toByteArray()), new DatabaseEntry(data));
            if (result != OperationStatus.SUCCESS) {
                throw new Exception("OperationStatus: " + result);
            }
        }
        catch (Exception ex) {
            throw new HGException("Failed to store hypergraph raw byte []: " + ex.toString(), ex);
        }
    }

    @Override
    public HGPersistentHandle store(HGPersistentHandle handle, HGPersistentHandle[] link) {
        DatabaseEntry key = new DatabaseEntry(handle.toByteArray());
        DatabaseEntry value = new DatabaseEntry();
        this.linkBinding.objectToEntry(link, value);
        try {
            OperationStatus result = this.data_db.put(this.txn().getBDBTransaction(), key, value);
            if (result != OperationStatus.SUCCESS) {
                throw new Exception("OperationStatus: " + result);
            }
        }
        catch (Exception ex) {
            throw new HGException("Failed to store hypergraph link: " + ex.toString(), ex);
        }
        return handle;
    }

    @Override
    public void addIncidenceLink(HGPersistentHandle handle, HGPersistentHandle newLink) {
        Object cursor = null;
        try {
            DatabaseEntry key = new DatabaseEntry(handle.toByteArray());
            DatabaseEntry value = new DatabaseEntry(newLink.toByteArray());
            OperationStatus result = this.incidence_db.putNoDupData(this.txn().getBDBTransaction(), key, value);
            if (result != OperationStatus.SUCCESS && result != OperationStatus.KEYEXIST) {
                throw new Exception("OperationStatus: " + result);
            }
        }
        catch (Exception ex) {
            throw new HGException("Failed to update incidence set for handle " + handle + ": " + ex.toString(), ex);
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    @Override
    public boolean containsLink(HGPersistentHandle handle) {
        DatabaseEntry key = new DatabaseEntry(handle.toByteArray());
        DatabaseEntry value = new DatabaseEntry();
        try {
            if (this.data_db.get(this.txn().getBDBTransaction(), key, value, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                return true;
            }
        }
        catch (DatabaseException ex) {
            throw new HGException("Failed to retrieve link with handle " + handle + ": " + ex.toString(), ex);
        }
        return false;
    }

    @Override
    public byte[] getData(HGPersistentHandle handle) {
        try {
            DatabaseEntry key = new DatabaseEntry(handle.toByteArray());
            DatabaseEntry value = new DatabaseEntry();
            if (this.primitive_db.get(this.txn().getBDBTransaction(), key, value, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                return value.getData();
            }
            return null;
        }
        catch (Exception ex) {
            throw new HGException("Failed to retrieve link with handle " + handle, ex);
        }
    }

    @Override
    public HGRandomAccessResult<HGPersistentHandle> getIncidenceResultSet(HGPersistentHandle handle) {
        if (handle == null) {
            throw new NullPointerException("HGStore.getIncidenceSet called with a null handle.");
        }
        Cursor cursor = null;
        try {
            DatabaseEntry key = new DatabaseEntry(handle.toByteArray());
            DatabaseEntry value = new DatabaseEntry();
            TransactionBDBImpl tx = this.txn();
            cursor = this.incidence_db.openCursor(tx.getBDBTransaction(), this.cursorConfig);
            OperationStatus status = cursor.getSearchKey(key, value, LockMode.DEFAULT);
            if (status == OperationStatus.NOTFOUND) {
                cursor.close();
                return HGSearchResult.EMPTY;
            }
            return new SingleKeyResultSet<HGPersistentHandle>(tx.attachCursor(cursor), key, BAtoHandle.getInstance(this.handleFactory));
        }
        catch (Throwable ex) {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            throw new HGException("Failed to retrieve incidence set for handle " + handle + ": " + ex.toString(), ex);
        }
    }

    @Override
    public long getIncidenceSetCardinality(HGPersistentHandle handle) {
        long l;
        if (handle == null) {
            throw new NullPointerException("HGStore.getIncidenceSetCardinality called with a null handle.");
        }
        Cursor cursor = null;
        try {
            DatabaseEntry key = new DatabaseEntry(handle.toByteArray());
            DatabaseEntry value = new DatabaseEntry();
            cursor = this.incidence_db.openCursor(this.txn().getBDBTransaction(), this.cursorConfig);
            OperationStatus status = cursor.getSearchKey(key, value, LockMode.DEFAULT);
            if (status == OperationStatus.NOTFOUND) {
                long l2 = 0L;
                return l2;
            }
            l = cursor.count();
        }
        catch (Exception ex) {
            throw new HGException("Failed to retrieve incidence set for handle " + handle + ": " + ex.toString(), ex);
        }
        finally {
            try {
                cursor.close();
            }
            catch (Throwable t) {}
        }
        return l;
    }

    @Override
    public HGPersistentHandle[] getLink(HGPersistentHandle handle) {
        try {
            DatabaseEntry key = new DatabaseEntry(handle.toByteArray());
            DatabaseEntry value = new DatabaseEntry();
            if (this.data_db.get(this.txn().getBDBTransaction(), key, value, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                return (HGPersistentHandle[])this.linkBinding.entryToObject(value);
            }
            return null;
        }
        catch (Exception ex) {
            throw new HGException("Failed to retrieve link with handle " + handle, ex);
        }
    }

    @Override
    public HGTransactionFactory getTransactionFactory() {
        return new HGTransactionFactory(){

            @Override
            public HGStorageTransaction createTransaction(HGTransactionContext context, HGTransactionConfig config, HGTransaction parent) {
                try {
                    TransactionConfig tconfig = new TransactionConfig();
                    if (BDBStorageImplementation.this.env.getConfig().getMultiversion() && config.isReadonly()) {
                        tconfig.setSnapshot(true);
                    }
                    tconfig.setWriteNoSync(true);
                    Transaction tx = null;
                    tx = parent != null ? BDBStorageImplementation.this.env.beginTransaction(((TransactionBDBImpl)parent.getStorageTransaction()).getBDBTransaction(), tconfig) : BDBStorageImplementation.this.env.beginTransaction(null, tconfig);
                    return new TransactionBDBImpl(tx, BDBStorageImplementation.this.env);
                }
                catch (DatabaseException ex) {
                    ex.printStackTrace(System.err);
                    throw new HGException("Failed to create BerkeleyDB transaction object.", ex);
                }
            }
        };
    }

    @Override
    public void removeData(HGPersistentHandle handle) {
        if (handle == null) {
            throw new NullPointerException("HGStore.remove called with a null handle.");
        }
        try {
            DatabaseEntry key = new DatabaseEntry(handle.toByteArray());
            this.primitive_db.delete(this.txn().getBDBTransaction(), key);
        }
        catch (Exception ex) {
            throw new HGException("Failed to remove value with handle " + handle + ": " + ex.toString(), ex);
        }
    }

    @Override
    public void removeIncidenceLink(HGPersistentHandle handle, HGPersistentHandle oldLink) {
        Cursor cursor = null;
        try {
            DatabaseEntry key = new DatabaseEntry(handle.toByteArray());
            DatabaseEntry value = new DatabaseEntry(oldLink.toByteArray());
            cursor = this.incidence_db.openCursor(this.txn().getBDBTransaction(), this.cursorConfig);
            OperationStatus status = cursor.getSearchBoth(key, value, LockMode.DEFAULT);
            if (status == OperationStatus.SUCCESS) {
                cursor.delete();
            }
        }
        catch (Exception ex) {
            throw new HGException("Failed to update incidence set for handle " + handle + ": " + ex.toString(), ex);
        }
        finally {
            if (cursor != null) {
                try {
                    cursor.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    @Override
    public void removeIncidenceSet(HGPersistentHandle handle) {
        try {
            DatabaseEntry key = new DatabaseEntry(handle.toByteArray());
            this.incidence_db.delete(this.txn().getBDBTransaction(), key);
        }
        catch (Exception ex) {
            throw new HGException("Failed to remove incidence set of handle " + handle + ": " + ex.toString(), ex);
        }
    }

    boolean checkIndexExisting(String name) {
        if (this.openIndices.get(name) != null) {
            return true;
        }
        DatabaseConfig cfg = new DatabaseConfig();
        cfg.setAllowCreate(false);
        Database db = null;
        try {
            db = this.env.openDatabase(null, "hgstore_idx_" + name, null, cfg);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (db != null) {
            try {
                db.close();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <KeyType, ValueType> HGIndex<KeyType, ValueType> getIndex(String name, ByteArrayConverter<KeyType> keyConverter, ByteArrayConverter<ValueType> valueConverter, Comparator<?> comparator, boolean isBidirectional, boolean createIfNecessary) {
        HGIndex<?, ?> idx;
        this.indicesLock.readLock().lock();
        try {
            idx = this.openIndices.get(name);
            if (idx != null) {
                HGIndex<?, ?> hGIndex = idx;
                return hGIndex;
            }
            if (!this.checkIndexExisting(name) && !createIfNecessary) {
                HGIndex<KeyType, ValueType> hGIndex = null;
                return hGIndex;
            }
        }
        finally {
            this.indicesLock.readLock().unlock();
        }
        this.indicesLock.writeLock().lock();
        try {
            idx = this.openIndices.get(name);
            if (idx != null) {
                HGIndex<?, ?> hGIndex = idx;
                return hGIndex;
            }
            if (!this.checkIndexExisting(name) && !createIfNecessary) {
                HGIndex<KeyType, ValueType> hGIndex = null;
                return hGIndex;
            }
            DefaultIndexImpl result = null;
            result = isBidirectional ? new DefaultBiIndexImpl<KeyType, ValueType>(name, this, this.store.getTransactionManager(), keyConverter, valueConverter, comparator) : new DefaultIndexImpl<KeyType, ValueType>(name, this, this.store.getTransactionManager(), keyConverter, valueConverter, comparator);
            result.open();
            this.openIndices.put(name, result);
            DefaultIndexImpl defaultIndexImpl = result;
            return defaultIndexImpl;
        }
        finally {
            this.indicesLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeIndex(String name) {
        this.indicesLock.writeLock().lock();
        try {
            HGIndex<?, ?> idx = this.openIndices.get(name);
            if (idx != null) {
                idx.close();
                this.openIndices.remove(name);
            }
            try {
                this.env.removeDatabase(null, "hgstore_idx_" + name, null);
            }
            catch (Exception e) {
                throw new HGException(e);
            }
        }
        finally {
            this.indicesLock.writeLock().unlock();
        }
    }

    static {
        if (System.getProperty("os.name").toLowerCase().indexOf("win") > -1) {
            System.loadLibrary("libdb50");
            System.loadLibrary("libdb_java50");
        }
    }

    class CheckPointThread
    extends Thread {
        boolean stop = false;
        boolean running = false;

        CheckPointThread() {
            this.setName("HGCHECKPOINT");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try {
                this.running = true;
                while (!this.stop) {
                    Thread.sleep(60000L);
                    if (this.stop) continue;
                    try {
                        BDBStorageImplementation.this.env.checkpoint(null);
                    }
                    catch (DatabaseException ex) {
                        throw new Error(ex);
                        return;
                    }
                }
            }
            catch (InterruptedException ex) {
                if (!this.stop) return;
                try {
                    BDBStorageImplementation.this.env.checkpoint(null);
                    return;
                }
                catch (DatabaseException dx) {
                    throw new Error(dx);
                }
            }
            catch (Throwable t) {
                System.err.println("HGDB CHECKPOINT THREAD exiting with: " + t.toString() + ", stack trace follows...");
                t.printStackTrace(System.err);
                return;
            }
            finally {
                this.running = false;
            }
        }
    }
}

