/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.storage;

import com.sleepycat.db.DatabaseConfig;
import com.sleepycat.db.DatabaseType;
import com.sleepycat.db.EnvironmentConfig;
import com.sleepycat.db.LockDetectMode;
import java.io.OutputStream;

public class BDBConfig {
    public static final long DEFAULT_STORE_CACHE = 0x1400000L;
    public static final int DEFAULT_NUMBER_OF_STORAGE_CACHES = 1;
    private EnvironmentConfig envConfig = new EnvironmentConfig();
    private DatabaseConfig dbConfig = new DatabaseConfig();
    private boolean storageMVCC = true;

    private void resetDefaults() {
        this.envConfig.setAllowCreate(true);
        this.envConfig.setInitializeCache(true);
        this.envConfig.setCacheSize(0x1400000L);
        this.envConfig.setCacheCount(1);
        this.envConfig.setErrorPrefix("BERKELEYDB");
        this.envConfig.setErrorStream((OutputStream)System.out);
        this.dbConfig.setAllowCreate(true);
        this.dbConfig.setType(DatabaseType.BTREE);
    }

    public BDBConfig() {
        this.resetDefaults();
    }

    public EnvironmentConfig getEnvironmentConfig() {
        return this.envConfig;
    }

    public DatabaseConfig getDatabaseConfig() {
        return this.dbConfig;
    }

    public void configureTransactional() {
        this.envConfig.setInitializeLogging(true);
        this.envConfig.setTransactional(true);
        if (!this.storageMVCC) {
            this.envConfig.setInitializeLocking(true);
            this.envConfig.setLockDetectMode(LockDetectMode.RANDOM);
            this.envConfig.setMaxLockers(2000);
            this.envConfig.setMaxLockObjects(20000);
            this.envConfig.setMaxLocks(20000);
        } else {
            this.envConfig.setMultiversion(true);
            this.envConfig.setTxnSnapshot(true);
        }
        this.envConfig.setTxnWriteNoSync(true);
        this.envConfig.setCachePageSize(4096);
        long maxActive = this.envConfig.getCacheSize() / (long)this.envConfig.getCachePageSize();
        this.envConfig.setTxnMaxActive((int)maxActive * 10);
        this.envConfig.setRunRecovery(true);
        this.envConfig.setRegister(true);
        this.envConfig.setLogAutoRemove(true);
        this.dbConfig.setTransactional(true);
        if (this.storageMVCC) {
            this.dbConfig.setMultiversion(true);
        }
    }

    public boolean isStorageMVCC() {
        return this.storageMVCC;
    }

    public void setStorageMVCC(boolean storageMVCC) {
        this.storageMVCC = storageMVCC;
    }
}

