/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.query.impl;

import java.util.NoSuchElementException;
import org.hypergraphdb.HGRandomAccessResult;
import org.hypergraphdb.HGSearchResult;
import org.hypergraphdb.query.impl.RSCombiner;

public class ZigZagIntersectionResult<T>
implements HGRandomAccessResult<T>,
RSCombiner<T> {
    private static final Object UNKNOWN = new Object();
    private HGRandomAccessResult<T> left;
    private HGRandomAccessResult<T> right;
    private Object current = UNKNOWN;
    private Object next = UNKNOWN;
    private Object prev = UNKNOWN;

    private void swap() {
        HGRandomAccessResult<T> tmp = this.left;
        this.left = this.right;
        this.right = tmp;
    }

    private T advance() {
        boolean use_next = true;
        block4: while (true) {
            Object x;
            if (!this.left.hasNext() && use_next || !this.right.hasNext()) {
                return null;
            }
            if (use_next) {
                x = this.left.next();
            } else {
                x = this.left.current();
                use_next = true;
            }
            switch (this.right.goTo(x, false)) {
                case found: {
                    return (T)x;
                }
                case close: {
                    use_next = false;
                    this.swap();
                    continue block4;
                }
            }
            break;
        }
        return null;
    }

    private T back() {
        T result = null;
        while (this.left.hasPrev() && this.right.hasPrev()) {
            Object x = this.left.prev();
            if (this.right.goTo(x, false) == HGRandomAccessResult.GotoResult.found) {
                result = x;
                break;
            }
            this.swap();
        }
        return result;
    }

    private boolean positionTo(HGRandomAccessResult<T> left_or_right) {
        if (this.left != left_or_right) {
            this.swap();
        }
        block4: while (true) {
            switch (this.right.goTo(this.left.current(), false)) {
                case found: {
                    this.current = this.left.current();
                    this.next = this.prev = UNKNOWN;
                    return true;
                }
                case close: {
                    this.swap();
                    continue block4;
                }
            }
            break;
        }
        return false;
    }

    public ZigZagIntersectionResult() {
    }

    public ZigZagIntersectionResult(HGRandomAccessResult<T> left, HGRandomAccessResult<T> right) {
        this.init(left, right);
    }

    @Override
    public void init(HGSearchResult<T> left, HGSearchResult<T> right) {
        this.left = (HGRandomAccessResult)left;
        this.right = (HGRandomAccessResult)right;
    }

    @Override
    public void goBeforeFirst() {
        this.left.goBeforeFirst();
        this.right.goBeforeFirst();
    }

    @Override
    public void goAfterLast() {
        this.left.goAfterLast();
        this.right.goAfterLast();
    }

    @Override
    public HGRandomAccessResult.GotoResult goTo(T value, boolean exactMatch) {
        HGRandomAccessResult<T> starting_left = this.left;
        HGRandomAccessResult<T> starting_right = this.right;
        Object save_left = null;
        Object save_right = null;
        try {
            save_left = this.left.current();
            save_right = this.right.current();
        }
        catch (NoSuchElementException ex) {
            return HGRandomAccessResult.GotoResult.nothing;
        }
        HGRandomAccessResult.GotoResult r_l = this.left.goTo(value, exactMatch);
        if (r_l == HGRandomAccessResult.GotoResult.nothing) {
            return HGRandomAccessResult.GotoResult.nothing;
        }
        HGRandomAccessResult.GotoResult r_r = this.right.goTo(value, exactMatch);
        if (r_r == HGRandomAccessResult.GotoResult.nothing) {
            starting_left.goTo(save_left, true);
            return HGRandomAccessResult.GotoResult.nothing;
        }
        if (r_l == HGRandomAccessResult.GotoResult.found) {
            if (r_r == HGRandomAccessResult.GotoResult.found) {
                this.current = this.left.current();
                this.next = this.prev = UNKNOWN;
                return HGRandomAccessResult.GotoResult.found;
            }
            if (this.positionTo(this.right)) {
                return HGRandomAccessResult.GotoResult.close;
            }
            starting_left.goTo(save_left, true);
            starting_right.goTo(save_right, true);
            return HGRandomAccessResult.GotoResult.nothing;
        }
        if (r_r == HGRandomAccessResult.GotoResult.found) {
            if (this.positionTo(this.left)) {
                return HGRandomAccessResult.GotoResult.close;
            }
            starting_left.goTo(save_left, true);
            starting_right.goTo(save_right, true);
            return HGRandomAccessResult.GotoResult.nothing;
        }
        int cmp = ((Comparable)this.left.current()).compareTo(this.right.current());
        if (cmp == 0 && this.positionTo(this.left) || cmp > 0 && this.positionTo(this.left) || this.positionTo(this.right)) {
            return HGRandomAccessResult.GotoResult.close;
        }
        starting_left.goTo(save_left, true);
        starting_right.goTo(save_right, true);
        return HGRandomAccessResult.GotoResult.nothing;
    }

    @Override
    public void close() {
        this.left.close();
        this.right.close();
    }

    @Override
    public T current() {
        if (this.current == UNKNOWN) {
            throw new NoSuchElementException();
        }
        return (T)this.current;
    }

    @Override
    public boolean isOrdered() {
        return true;
    }

    @Override
    public boolean hasPrev() {
        if (this.prev == UNKNOWN) {
            this.prev = this.back();
        }
        return this.prev != null;
    }

    @Override
    public T prev() {
        if (!this.hasPrev()) {
            throw new NoSuchElementException();
        }
        this.next = this.current;
        this.current = this.prev;
        this.prev = UNKNOWN;
        return (T)this.current;
    }

    @Override
    public boolean hasNext() {
        if (this.next == UNKNOWN) {
            this.next = this.advance();
        }
        return this.next != null;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.prev = this.current;
        this.current = this.next;
        this.next = UNKNOWN;
        return (T)this.current;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

