/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.query.impl;

import java.util.NoSuchElementException;
import org.hypergraphdb.HGSearchResult;

public class UnionResult
implements HGSearchResult {
    private HGSearchResult left;
    private HGSearchResult right;
    private boolean leftBOF = false;
    private boolean rightBOF = false;
    private boolean leftEOF = false;
    private boolean rightEOF = false;
    private boolean move_both = true;
    private HGSearchResult last_choice = null;

    private Object select(Comparable L, Comparable R) {
        int comp = L.compareTo(R);
        if (comp == 0) {
            this.last_choice = this.left;
            this.move_both = true;
            return L;
        }
        if (comp < 0) {
            this.last_choice = this.left;
            this.move_both = false;
            return L;
        }
        this.last_choice = this.right;
        this.move_both = false;
        return R;
    }

    private Object selectBack(Comparable L, Comparable R) {
        int comp = L.compareTo(R);
        if (comp == 0) {
            this.last_choice = this.left;
            this.move_both = true;
            return L;
        }
        if (comp < 0) {
            this.last_choice = this.right;
            this.move_both = false;
            return R;
        }
        this.last_choice = this.left;
        this.move_both = false;
        return L;
    }

    public UnionResult(HGSearchResult left, HGSearchResult right) {
        this.left = left;
        this.right = right;
    }

    public Object current() {
        if (this.last_choice == null) {
            throw new NoSuchElementException();
        }
        return this.last_choice.current();
    }

    @Override
    public void close() {
        this.left.close();
        this.right.close();
    }

    @Override
    public Object prev() {
        if (!this.hasPrev()) {
            throw new NoSuchElementException();
        }
        if (this.move_both) {
            if (this.left.hasPrev()) {
                if (!this.right.hasPrev()) {
                    this.last_choice = this.left;
                    this.move_both = false;
                    this.rightBOF = true;
                    return this.left.prev();
                }
                return this.selectBack((Comparable)this.left.prev(), (Comparable)this.right.prev());
            }
            this.last_choice = this.right;
            this.move_both = false;
            this.leftBOF = true;
            return this.right.prev();
        }
        if (this.last_choice == this.left) {
            if (!this.left.hasPrev()) {
                this.last_choice = this.right;
                this.move_both = false;
                this.leftBOF = true;
                return this.right.current();
            }
            if (this.rightBOF) {
                return this.left.prev();
            }
            return this.selectBack((Comparable)this.left.prev(), (Comparable)this.right.current());
        }
        if (this.last_choice == this.right) {
            if (!this.right.hasPrev()) {
                this.last_choice = this.left;
                this.move_both = false;
                this.rightBOF = true;
                return this.left.current();
            }
            if (this.leftBOF) {
                return this.right.prev();
            }
            return this.selectBack((Comparable)this.left.current(), (Comparable)this.right.prev());
        }
        throw new NoSuchElementException("This should never be thrown from here!!!");
    }

    @Override
    public boolean hasPrev() {
        if (this.left.hasPrev()) {
            return true;
        }
        if (this.right.hasPrev()) {
            return true;
        }
        if (this.last_choice == null) {
            return false;
        }
        if (this.last_choice == this.left && !this.rightBOF) {
            return ((Comparable)this.left.current()).compareTo(this.right.current()) > 0;
        }
        if (this.last_choice == this.right && !this.leftBOF) {
            return ((Comparable)this.right.current()).compareTo(this.left.current()) > 0;
        }
        return false;
    }

    @Override
    public boolean hasNext() {
        if (this.left.hasNext()) {
            return true;
        }
        if (this.right.hasNext()) {
            return true;
        }
        if (this.last_choice == null) {
            return false;
        }
        if (this.last_choice == this.left && !this.rightEOF) {
            return ((Comparable)this.left.current()).compareTo(this.right.current()) < 0;
        }
        if (this.last_choice == this.right && !this.leftEOF) {
            return ((Comparable)this.right.current()).compareTo(this.left.current()) < 0;
        }
        return false;
    }

    @Override
    public Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.move_both) {
            if (this.left.hasNext()) {
                if (!this.right.hasNext()) {
                    this.last_choice = this.left;
                    this.move_both = false;
                    this.rightEOF = true;
                    return this.left.next();
                }
                return this.select((Comparable)this.left.next(), (Comparable)this.right.next());
            }
            this.last_choice = this.right;
            this.move_both = false;
            this.leftEOF = true;
            return this.right.next();
        }
        if (this.last_choice == this.left) {
            if (!this.left.hasNext()) {
                this.last_choice = this.right;
                this.move_both = false;
                this.leftEOF = true;
                return this.right.current();
            }
            if (this.rightEOF) {
                return this.left.next();
            }
            return this.select((Comparable)this.left.next(), (Comparable)this.right.current());
        }
        if (this.last_choice == this.right) {
            if (!this.right.hasNext()) {
                this.last_choice = this.left;
                this.move_both = false;
                this.rightEOF = true;
                return this.left.current();
            }
            if (this.leftEOF) {
                return this.right.next();
            }
            return this.select((Comparable)this.left.current(), (Comparable)this.right.next());
        }
        throw new NoSuchElementException("This should never be thrown from here!!!");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isOrdered() {
        return true;
    }
}

