/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.query.impl;

import org.hypergraphdb.HGQuery;
import org.hypergraphdb.HGSearchResult;
import org.hypergraphdb.query.impl.UnionResult;

public class UnionQuery
extends HGQuery {
    private HGQuery left;
    private HGQuery right;

    public UnionQuery(HGQuery left, HGQuery right) {
        this.left = left;
        this.right = right;
    }

    public HGSearchResult execute() {
        HGSearchResult leftResult = this.left.execute();
        HGSearchResult rightResult = this.right.execute();
        if (!leftResult.hasNext() && !rightResult.hasNext()) {
            leftResult.close();
            rightResult.close();
            return HGSearchResult.EMPTY;
        }
        if (!leftResult.hasNext()) {
            leftResult.close();
            return rightResult;
        }
        if (!rightResult.hasNext()) {
            rightResult.close();
            return leftResult;
        }
        return new UnionResult(leftResult, rightResult);
    }
}

