/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.query.impl;

import org.hypergraphdb.HGException;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGQuery;
import org.hypergraphdb.HGSearchResult;
import org.hypergraphdb.algorithms.HGTraversal;
import org.hypergraphdb.query.impl.MappedResult;
import org.hypergraphdb.query.impl.TraversalResult;
import org.hypergraphdb.util.Mapping;
import org.hypergraphdb.util.Pair;

public class TraversalBasedQuery
extends HGQuery {
    private HGTraversal traversal;
    private ReturnType returnType = ReturnType.both;

    public TraversalBasedQuery(HGTraversal traversal) {
        this.traversal = traversal;
    }

    public TraversalBasedQuery(HGTraversal traversal, ReturnType returnType) {
        this(traversal);
        this.returnType = returnType;
    }

    public HGTraversal getTraversal() {
        return this.traversal;
    }

    public HGSearchResult<?> execute() {
        switch (this.returnType) {
            case both: {
                return new TraversalResult(this.traversal);
            }
            case targets: {
                return new MappedResult(new TraversalResult(this.traversal), new Mapping<Pair<HGHandle, HGHandle>, HGHandle>(){

                    @Override
                    public HGHandle eval(Pair<HGHandle, HGHandle> p) {
                        return p.getSecond();
                    }
                });
            }
            case links: {
                return new MappedResult(new TraversalResult(this.traversal), new Mapping<Pair<HGHandle, HGHandle>, HGHandle>(){

                    @Override
                    public HGHandle eval(Pair<HGHandle, HGHandle> p) {
                        return p.getFirst();
                    }
                });
            }
        }
        throw new HGException("This should never happen ;)");
    }

    public ReturnType getReturnType() {
        return this.returnType;
    }

    public void setReturnType(ReturnType returnType) {
        this.returnType = returnType;
    }

    public static enum ReturnType {
        targets,
        links,
        both;

    }
}

