/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.query.impl;

import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGQuery;
import org.hypergraphdb.HGSearchResult;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.query.HGAtomPredicate;
import org.hypergraphdb.query.impl.FilteredResultSet;
import org.hypergraphdb.util.HGUtils;

public final class PredicateBasedFilter
extends HGQuery {
    private HGQuery query;
    private HGAtomPredicate predicate;

    public PredicateBasedFilter(HyperGraph hg2, HGQuery query, HGAtomPredicate predicate) {
        this.graph = hg2;
        this.query = query;
        this.predicate = predicate;
    }

    public HGSearchResult execute() {
        HGSearchResult baseResult = this.query.execute();
        try {
            while (baseResult.hasNext()) {
                Object next = baseResult.next();
                if (!this.predicate.satisfies(this.graph, (HGHandle)next)) continue;
                return new FilteredResultSet(this.graph, baseResult, this.predicate, 1);
            }
        }
        catch (Throwable t) {
            HGUtils.closeNoException(baseResult);
            HGUtils.wrapAndRethrow(t);
        }
        baseResult.close();
        return HGSearchResult.EMPTY;
    }
}

