/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.query.impl;

import java.util.NoSuchElementException;
import org.hypergraphdb.HGSearchResult;
import org.hypergraphdb.query.impl.KeyBasedQuery;

public class PipedResult<Key, Value>
implements HGSearchResult<Value> {
    private HGSearchResult<Key> in;
    private KeyBasedQuery<Key, Value> pipe;
    private HGSearchResult<Value> currentPiped = null;
    private HGSearchResult<Value> nextPiped = null;
    private HGSearchResult<Value> previousPiped = null;
    private boolean own_in;

    public PipedResult(HGSearchResult<Key> in, KeyBasedQuery<Key, Value> pipe, boolean own_in) {
        this.in = in;
        this.pipe = pipe;
        this.own_in = own_in;
        if (in.hasNext()) {
            pipe.setKey(in.next());
            this.currentPiped = pipe.execute();
        }
    }

    @Override
    public Value current() {
        if (this.currentPiped == null) {
            throw new NoSuchElementException();
        }
        return this.currentPiped.current();
    }

    @Override
    public void close() {
        if (this.currentPiped != null) {
            this.currentPiped.close();
            this.currentPiped = null;
        }
        if (this.nextPiped != null) {
            this.nextPiped.close();
            this.nextPiped = null;
        }
        if (this.previousPiped != null) {
            this.previousPiped.close();
            this.previousPiped = null;
        }
        if (this.own_in && this.in != null) {
            this.in.close();
        }
    }

    @Override
    public boolean hasPrev() {
        if (this.currentPiped == null) {
            return false;
        }
        if (this.currentPiped.hasPrev()) {
            return true;
        }
        if (this.previousPiped != null) {
            return this.previousPiped.hasPrev();
        }
        if (!this.in.hasPrev()) {
            return false;
        }
        do {
            this.pipe.setKey(this.in.prev());
            this.previousPiped = this.pipe.execute();
            if (this.previousPiped.hasNext()) {
                do {
                    this.previousPiped.next();
                } while (this.previousPiped.hasNext());
                return true;
            }
            this.previousPiped.close();
            this.previousPiped = null;
        } while (this.in.hasPrev());
        return false;
    }

    @Override
    public Value prev() {
        if (!this.hasPrev()) {
            throw new NoSuchElementException();
        }
        if (this.currentPiped.hasPrev()) {
            return (Value)this.currentPiped.prev();
        }
        if (this.nextPiped != null) {
            this.nextPiped.close();
        }
        this.nextPiped = this.currentPiped;
        this.currentPiped = this.previousPiped;
        this.previousPiped = null;
        return (Value)this.currentPiped.prev();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("PipedResult.remove");
    }

    @Override
    public boolean hasNext() {
        if (this.currentPiped == null) {
            return false;
        }
        if (this.currentPiped.hasNext()) {
            return true;
        }
        if (this.nextPiped != null) {
            return this.nextPiped.hasNext();
        }
        if (!this.in.hasNext()) {
            return false;
        }
        do {
            this.pipe.setKey(this.in.next());
            this.nextPiped = this.pipe.execute();
            if (this.nextPiped.hasNext()) {
                return true;
            }
            this.nextPiped.close();
            this.nextPiped = null;
        } while (this.in.hasNext());
        return false;
    }

    @Override
    public Value next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.currentPiped.hasNext()) {
            return (Value)this.currentPiped.next();
        }
        if (this.previousPiped != null) {
            this.previousPiped.close();
        }
        this.previousPiped = this.currentPiped;
        this.currentPiped = this.nextPiped;
        this.nextPiped = null;
        return (Value)this.currentPiped.next();
    }

    @Override
    public boolean isOrdered() {
        return false;
    }
}

