/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.query.impl;

import org.hypergraphdb.HGRandomAccessResult;
import org.hypergraphdb.HGSearchResult;
import org.hypergraphdb.query.impl.RSCombiner;
import org.hypergraphdb.query.impl.ZigZagIntersectionResult;
import org.hypergraphdb.util.ArrayBasedSet;

public class InMemoryIntersectionResult<T>
implements HGRandomAccessResult<T>,
RSCombiner<T> {
    private HGRandomAccessResult<T> left;
    private HGRandomAccessResult<T> right;
    private HGRandomAccessResult<T> intersection = null;

    private void intersect() {
        if (this.intersection != null) {
            return;
        }
        ArrayBasedSet<Object> set = new ArrayBasedSet<Object>(new Object[0]);
        ZigZagIntersectionResult<T> zigzag = new ZigZagIntersectionResult<T>(this.left, this.right);
        while (zigzag.hasNext()) {
            set.add(zigzag.next());
        }
        this.intersection = set.getSearchResult();
        this.left.close();
        this.right.close();
        this.right = null;
        this.left = null;
    }

    @Override
    public void goBeforeFirst() {
        this.intersect();
        this.intersection.goBeforeFirst();
    }

    @Override
    public void goAfterLast() {
        this.intersect();
        this.intersection.goAfterLast();
    }

    @Override
    public HGRandomAccessResult.GotoResult goTo(T value, boolean exactMatch) {
        this.intersect();
        return this.intersection.goTo(value, exactMatch);
    }

    @Override
    public void close() {
        if (this.intersection != null) {
            this.intersection.close();
        }
    }

    @Override
    public T current() {
        this.intersect();
        return this.intersection.current();
    }

    @Override
    public boolean isOrdered() {
        return true;
    }

    @Override
    public boolean hasPrev() {
        this.intersect();
        return this.intersection.hasPrev();
    }

    @Override
    public T prev() {
        this.intersect();
        return this.intersection.prev();
    }

    @Override
    public boolean hasNext() {
        this.intersect();
        return this.intersection.hasNext();
    }

    @Override
    public T next() {
        this.intersect();
        return (T)this.intersection.next();
    }

    @Override
    public void remove() {
        this.intersect();
        this.intersection.remove();
    }

    @Override
    public void init(HGSearchResult<T> l, HGSearchResult<T> r) {
        this.left = (HGRandomAccessResult)l;
        this.right = (HGRandomAccessResult)r;
    }
}

