/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.query.cond2qry;

import java.util.ArrayList;
import java.util.Iterator;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGQuery;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.query.HGQueryCondition;
import org.hypergraphdb.query.IncidentCondition;
import org.hypergraphdb.query.LinkCondition;
import org.hypergraphdb.query.cond2qry.ConditionToQuery;
import org.hypergraphdb.query.cond2qry.QueryMetaData;
import org.hypergraphdb.query.cond2qry.ToQueryMap;
import org.hypergraphdb.query.impl.IntersectionQuery;
import org.hypergraphdb.query.impl.ZigZagIntersectionResult;

public class LinkToQuery
implements ConditionToQuery {
    @Override
    public QueryMetaData getMetaData(HyperGraph graph, HGQueryCondition c) {
        QueryMetaData qmd = ((LinkCondition)c).targets().size() == 0 ? QueryMetaData.EMPTY.clone(c) : QueryMetaData.ORDERED.clone(c);
        qmd.predicateCost = 0.5;
        return qmd;
    }

    @Override
    public HGQuery<?> getQuery(HyperGraph graph, HGQueryCondition c) {
        LinkCondition lc = (LinkCondition)c;
        ArrayList L = new ArrayList();
        for (HGHandle t : lc.targets()) {
            L.add(ToQueryMap.toQuery(graph, new IncidentCondition(t)));
        }
        if (L.isEmpty()) {
            return HGQuery.NOP;
        }
        if (L.size() == 1) {
            return (HGQuery)L.get(0);
        }
        Iterator i = L.iterator();
        IntersectionQuery result = new IntersectionQuery((HGQuery)i.next(), (HGQuery)i.next(), new ZigZagIntersectionResult());
        while (i.hasNext()) {
            result = new IntersectionQuery((HGQuery)i.next(), result, new ZigZagIntersectionResult());
        }
        return result;
    }
}

