/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.query.cond2qry;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import org.hypergraphdb.HGException;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGIndex;
import org.hypergraphdb.HGQuery;
import org.hypergraphdb.HGSearchResult;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.algorithms.DefaultALGenerator;
import org.hypergraphdb.algorithms.HGBreadthFirstTraversal;
import org.hypergraphdb.atom.HGSubsumes;
import org.hypergraphdb.indexing.ByPartIndexer;
import org.hypergraphdb.indexing.ByTargetIndexer;
import org.hypergraphdb.indexing.HGIndexer;
import org.hypergraphdb.indexing.HGKeyIndexer;
import org.hypergraphdb.query.And;
import org.hypergraphdb.query.AtomPartCondition;
import org.hypergraphdb.query.AtomTypeCondition;
import org.hypergraphdb.query.AtomValueCondition;
import org.hypergraphdb.query.ComparisonOperator;
import org.hypergraphdb.query.HGQueryCondition;
import org.hypergraphdb.query.IncidentCondition;
import org.hypergraphdb.query.IndexCondition;
import org.hypergraphdb.query.IndexedPartCondition;
import org.hypergraphdb.query.LinkCondition;
import org.hypergraphdb.query.MapCondition;
import org.hypergraphdb.query.Not;
import org.hypergraphdb.query.Nothing;
import org.hypergraphdb.query.Or;
import org.hypergraphdb.query.OrderedLinkCondition;
import org.hypergraphdb.query.TypePlusCondition;
import org.hypergraphdb.query.TypedValueCondition;
import org.hypergraphdb.query.cond2qry.ConditionToQuery;
import org.hypergraphdb.query.cond2qry.QueryMetaData;
import org.hypergraphdb.query.cond2qry.ToQueryMap;
import org.hypergraphdb.query.cond2qry.ValueAsPredicateOnly;
import org.hypergraphdb.type.HGAtomType;
import org.hypergraphdb.type.TypeUtils;
import org.hypergraphdb.util.HGUtils;
import org.hypergraphdb.util.Pair;

public class ExpressionBasedQuery<ResultType>
extends HGQuery<ResultType> {
    private HGQuery<ResultType> query = null;
    private HGQueryCondition condition;

    private Pair<HGHandle, HGIndex> findIndex(HGKeyIndexer indexer) {
        HGBreadthFirstTraversal typeWalk = new HGBreadthFirstTraversal(indexer.getType(), new DefaultALGenerator(this.graph, HGQuery.hg.type(HGSubsumes.class), null, true, false, false));
        HGHandle type = indexer.getType();
        while (type != null) {
            indexer.setType(type);
            HGIndex idx = this.graph.getIndexManager().getIndex(indexer);
            if (idx != null) {
                return new Pair<HGHandle, HGIndex>(type, idx);
            }
            type = typeWalk.hasNext() ? typeWalk.next().getSecond() : null;
        }
        return null;
    }

    private static HGQueryCondition toDNF(HGQueryCondition C) {
        if (C instanceof And) {
            And and = (And)C;
            HashSet<HGQueryCondition> andSet = new HashSet<HGQueryCondition>();
            for (int i = 0; i < and.size(); ++i) {
                HGQueryCondition sub = (HGQueryCondition)and.get(i);
                if ((sub = ExpressionBasedQuery.toDNF(sub)) instanceof And) {
                    for (HGQueryCondition subsub : (And)sub) {
                        if (andSet.contains(subsub)) continue;
                        andSet.add(subsub);
                    }
                    continue;
                }
                if (sub instanceof Or) {
                    Or result = new Or();
                    for (HGQueryCondition subsub : (Or)sub) {
                        And newsub = new And();
                        newsub.add(subsub);
                        newsub.addAll(andSet);
                        newsub.addAll(and.subList(i + 1, and.size()));
                        result.add(newsub);
                    }
                    return ExpressionBasedQuery.toDNF(result);
                }
                andSet.add(sub);
            }
            and = new And();
            and.addAll(andSet);
            return and;
        }
        if (C instanceof Or) {
            Or or = (Or)C;
            HashSet<HGQueryCondition> orSet = new HashSet<HGQueryCondition>();
            for (int i = 0; i < or.size(); ++i) {
                HGQueryCondition sub = (HGQueryCondition)or.get(i);
                if ((sub = ExpressionBasedQuery.toDNF(sub)) instanceof Or) {
                    for (HGQueryCondition subsub : (Or)sub) {
                        if (orSet.contains(subsub)) continue;
                        orSet.add(subsub);
                    }
                    continue;
                }
                if (orSet.contains(sub)) continue;
                orSet.add(sub);
            }
            return or;
        }
        if (C instanceof MapCondition) {
            MapCondition mcond = (MapCondition)C;
            return new MapCondition(ExpressionBasedQuery.toDNF(mcond.getCondition()), mcond.getMapping());
        }
        return C;
    }

    private boolean checkConsistent(AtomTypeCondition c1, AtomTypeCondition c2) {
        HGHandle h1;
        HGHandle hGHandle = h1 = c1.getTypeHandle() != null ? c1.getTypeHandle() : this.graph.getTypeSystem().getTypeHandle(c1.getJavaClass());
        if (c2.getTypeHandle() != null) {
            return h1.equals(c2.getTypeHandle());
        }
        return h1.equals(this.graph.getTypeSystem().getTypeHandle(c2.getJavaClass()));
    }

    private boolean checkConsistent(TypedValueCondition c1, AtomTypeCondition c2) {
        HGHandle h1;
        HGHandle hGHandle = h1 = c1.getTypeHandle() != null ? c1.getTypeHandle() : this.graph.getTypeSystem().getTypeHandle(c1.getJavaClass());
        if (c2.getTypeHandle() != null) {
            return h1.equals(c2.getTypeHandle());
        }
        return h1.equals(this.graph.getTypeSystem().getTypeHandle(c2.getJavaClass()));
    }

    private boolean checkConsistent(TypedValueCondition tc, AtomValueCondition vc) {
        return HGUtils.eq(tc.getValue(), vc.getValue()) && tc.getOperator() == vc.getOperator();
    }

    private boolean checkConsistent(HGAtomType type, AtomPartCondition vc) {
        return TypeUtils.getProjection(this.graph, type, vc.getDimensionPath()) != null;
    }

    private HGQueryCondition simplify(HGQueryCondition cond) {
        if (cond instanceof And) {
            And in = (And)cond;
            And out = new And();
            out.addAll(in);
            AtomTypeCondition byType = null;
            AtomValueCondition byValue = null;
            TypedValueCondition byTypedValue = null;
            HashSet<OrderedLinkCondition> oLinks = new HashSet<OrderedLinkCondition>();
            HashSet<AtomPartCondition> byPart = new HashSet<AtomPartCondition>();
            boolean has_ordered = false;
            boolean has_ra = false;
            Iterator i = out.iterator();
            while (i.hasNext()) {
                HGQueryCondition c = (HGQueryCondition)i.next();
                if (c instanceof AtomTypeCondition) {
                    if (byType == null) {
                        if (byTypedValue != null) {
                            if (!this.checkConsistent(byTypedValue, (AtomTypeCondition)c)) {
                                return Nothing.Instance;
                            }
                            i.remove();
                            continue;
                        }
                        byType = (AtomTypeCondition)c;
                        continue;
                    }
                    if (this.checkConsistent(byType, (AtomTypeCondition)c)) {
                        i.remove();
                        continue;
                    }
                    return Nothing.Instance;
                }
                if (c instanceof AtomValueCondition) {
                    if (byValue == null) {
                        if (byTypedValue != null) {
                            if (!this.checkConsistent(byTypedValue, (AtomValueCondition)c)) {
                                return Nothing.Instance;
                            }
                            i.remove();
                            continue;
                        }
                        byValue = (AtomValueCondition)c;
                        continue;
                    }
                    if (byValue.equals((AtomValueCondition)c)) {
                        i.remove();
                        continue;
                    }
                    return Nothing.Instance;
                }
                if (c instanceof TypedValueCondition) {
                    if (byTypedValue == null) continue;
                    if (byTypedValue.equals((TypedValueCondition)c)) {
                        i.remove();
                        continue;
                    }
                    return Nothing.Instance;
                }
                if (c instanceof AtomPartCondition) {
                    byPart.add((AtomPartCondition)c);
                    continue;
                }
                if (c instanceof OrderedLinkCondition) {
                    oLinks.add((OrderedLinkCondition)c);
                    continue;
                }
                ConditionToQuery transform = (ConditionToQuery)ToQueryMap.getInstance().get(c.getClass());
                if (transform == null) continue;
                QueryMetaData qmd = transform.getMetaData(this.graph, c);
                has_ordered = has_ordered || qmd.ordered;
                has_ra = has_ra || qmd.randomAccess;
            }
            HGHandle typeHandle = null;
            if (byTypedValue != null) {
                if (byType != null) {
                    if (!this.checkConsistent(byTypedValue, byType)) {
                        return Nothing.Instance;
                    }
                    out.remove(byType);
                    if (byType.getTypeHandle() != null) {
                        typeHandle = byType.getTypeHandle();
                    }
                    byType = null;
                }
                if (byValue != null) {
                    if (!this.checkConsistent(byTypedValue, byValue)) {
                        return Nothing.Instance;
                    }
                    out.remove(byValue);
                    byValue = null;
                }
                if (typeHandle == null) {
                    typeHandle = byTypedValue.getTypeHandle() != null ? byTypedValue.getTypeHandle() : this.graph.getTypeSystem().getTypeHandle(byTypedValue.getJavaClass());
                }
            } else if (byType != null) {
                typeHandle = byType.getTypeHandle() != null ? byType.getTypeHandle() : this.graph.getTypeSystem().getTypeHandle(byType.getJavaClass());
                if (byValue != null) {
                    byTypedValue = new TypedValueCondition(typeHandle, byValue.getValue(), byValue.getOperator());
                    out.add(byTypedValue);
                    out.remove(byType);
                    out.remove(byValue);
                    byType = null;
                    byValue = null;
                }
            }
            if (typeHandle != null && byPart.size() > 0) {
                HGAtomType type = (HGAtomType)this.graph.get(typeHandle);
                if (type == null) {
                    throw new HGException("No type for type handle " + typeHandle + " in this HyperGraph instance.");
                }
                for (AtomPartCondition pc : byPart) {
                    if (!this.checkConsistent(type, pc)) {
                        return Nothing.Instance;
                    }
                    Pair<HGHandle, HGIndex> p = this.findIndex(new ByPartIndexer(typeHandle, pc.getDimensionPath()));
                    if (p == null) continue;
                    if (typeHandle.equals(p.getFirst())) {
                        if (byType != null) {
                            out.remove(byType);
                            byType = null;
                        } else if (byTypedValue != null) {
                            out.remove(byTypedValue);
                            out.add(new ValueAsPredicateOnly(byTypedValue.getValue(), byTypedValue.getOperator()));
                            byTypedValue = null;
                        }
                    }
                    out.remove(pc);
                    out.add(new IndexedPartCondition(p.getFirst(), p.getSecond(), pc.getValue(), pc.getOperator()));
                }
            }
            if (typeHandle != null) {
                for (OrderedLinkCondition c : oLinks) {
                    for (int ti = 0; ti < c.targets().length; ++ti) {
                        Pair<HGHandle, HGIndex> p;
                        HGHandle targetHandle = c.targets()[ti];
                        if (targetHandle.equals(this.graph.getHandleFactory().anyHandle()) || (p = this.findIndex(new ByTargetIndexer(typeHandle, ti))) == null) continue;
                        if (typeHandle.equals(p.getFirst())) {
                            if (byType != null) {
                                out.remove(byType);
                                byType = null;
                            } else if (byTypedValue != null) {
                                out.remove(byTypedValue);
                                out.add(new AtomValueCondition(byTypedValue.getValue(), byTypedValue.getOperator()));
                                byTypedValue = null;
                            }
                        }
                        out.remove(new IncidentCondition(targetHandle));
                        out.add(new IndexCondition(p.getSecond(), this.graph.getPersistentHandle(targetHandle)));
                    }
                }
            }
            return out;
        }
        if (cond instanceof Or) {
            Or in = (Or)cond;
            Or out = new Or();
            for (HGQueryCondition c : in) {
                if ((c = this.simplify(c)) instanceof Or) {
                    out.addAll((Or)c);
                    continue;
                }
                if (c == Nothing.Instance) continue;
                out.add(c);
            }
            return out;
        }
        if (cond instanceof MapCondition) {
            MapCondition mcond = (MapCondition)cond;
            return new MapCondition(this.simplify(mcond.getCondition()), mcond.getMapping());
        }
        return cond;
    }

    private List<AtomPartCondition> getAtomIndexedPartsConditions(HyperGraph graph, HGHandle hType, Object value) {
        ArrayList<AtomPartCondition> L = new ArrayList<AtomPartCondition>();
        List<HGIndexer> indexers = graph.getIndexManager().getIndexersForType(hType);
        if (indexers == null) {
            return L;
        }
        for (HGIndexer idx : indexers) {
            if (!(idx instanceof ByPartIndexer)) continue;
            String[] dimPath = ((ByPartIndexer)idx).getDimensionPath();
            Object partValue = TypeUtils.project(graph, hType, value, dimPath, true).getValue();
            L.add(new AtomPartCondition(dimPath, partValue));
        }
        return L;
    }

    private HGQueryCondition expand(HyperGraph graph, HGQueryCondition cond) {
        if (cond instanceof TypePlusCondition) {
            TypePlusCondition ac = (TypePlusCondition)cond;
            if (ac.getJavaClass() == null) {
                ac.setJavaClass(graph.getTypeSystem().getClassForType(ac.getBaseType()));
            } else if (ac.getBaseType() == null) {
                ac.setBaseType(graph.getTypeSystem().getTypeHandle(ac.getJavaClass()));
            }
            Or orCondition = new Or();
            for (HGHandle h : ac.getSubTypes(graph)) {
                orCondition.add(new AtomTypeCondition(h));
            }
            cond = orCondition;
        } else if (cond instanceof AtomTypeCondition) {
            AtomTypeCondition tc = (AtomTypeCondition)cond;
            if (tc.getJavaClass() == null) {
                tc.setJavaClass(graph.getTypeSystem().getClassForType(tc.getTypeHandle()));
            } else if (tc.getTypeHandle() == null) {
                tc.setTypeHandle(graph.getTypeSystem().getTypeHandle(tc.getJavaClass()));
            }
        } else if (cond instanceof TypedValueCondition && ((TypedValueCondition)cond).getOperator() == ComparisonOperator.EQ) {
            TypedValueCondition tc = (TypedValueCondition)cond;
            if (tc.getJavaClass() == null) {
                tc.setJavaClass(graph.getTypeSystem().getClassForType(tc.getTypeHandle()));
            } else if (tc.getTypeHandle() == null) {
                tc.setTypeHandle(graph.getTypeSystem().getTypeHandle(tc.getJavaClass()));
            }
            List<AtomPartCondition> indexedParts = this.getAtomIndexedPartsConditions(graph, tc.getTypeHandle(), tc.getValue());
            if (!indexedParts.isEmpty()) {
                And and = HGQuery.hg.and(cond);
                for (AtomPartCondition pc : indexedParts) {
                    and.add(pc);
                }
                cond = and;
            }
        } else if (cond instanceof AtomValueCondition && ((AtomValueCondition)cond).getOperator() == ComparisonOperator.EQ) {
            AtomValueCondition vc = (AtomValueCondition)cond;
            Object value = vc.getValue();
            if (value == null) {
                throw new HGException("Search by null values is not supported yet.");
            }
            HGHandle type = graph.getTypeSystem().getTypeHandle(value);
            List<AtomPartCondition> indexedParts = this.getAtomIndexedPartsConditions(graph, type, value);
            if (!indexedParts.isEmpty()) {
                And and = HGQuery.hg.and(cond, new AtomTypeCondition(type));
                for (AtomPartCondition pc : indexedParts) {
                    and.add(pc);
                }
                cond = and;
            }
        } else if (cond instanceof And) {
            HGQueryCondition statedType = null;
            And result = new And();
            for (HGQueryCondition sub : (And)cond) {
                HGQueryCondition expanded;
                if (sub instanceof AtomTypeCondition || sub instanceof TypedValueCondition) {
                    statedType = sub;
                }
                if ((expanded = this.expand(graph, sub)) instanceof And) {
                    result.addAll((And)expanded);
                    continue;
                }
                result.add(expanded);
            }
            if (statedType != null) {
                Iterator i = result.iterator();
                while (i.hasNext()) {
                    HGQueryCondition curr = (HGQueryCondition)i.next();
                    if (curr == statedType || !(curr instanceof AtomTypeCondition)) continue;
                    i.remove();
                }
            }
            cond = result;
        } else if (cond instanceof Or) {
            Or result = new Or();
            for (HGQueryCondition sub : (Or)cond) {
                result.add(this.expand(graph, sub));
            }
            cond = result;
        } else if (cond instanceof OrderedLinkCondition) {
            And result = new And();
            result.add(cond);
            for (HGHandle h : ((OrderedLinkCondition)cond).targets()) {
                if (h.equals(graph.getHandleFactory().anyHandle())) continue;
                result.add(new IncidentCondition(h));
            }
            cond = result;
        } else if (cond instanceof LinkCondition) {
            And result = new And();
            for (HGHandle h : ((LinkCondition)cond).targets()) {
                if (h.equals(graph.getHandleFactory().anyHandle())) continue;
                result.add(new IncidentCondition(h));
            }
            cond = result;
        } else if (cond instanceof MapCondition) {
            MapCondition mcond = (MapCondition)cond;
            cond = new MapCondition(this.expand(graph, mcond.getCondition()), mcond.getMapping());
        }
        return cond;
    }

    private void preprocess(HGQueryCondition c) {
        if (c instanceof LinkCondition) {
            LinkCondition lc = (LinkCondition)c;
            if (lc.getTargetSet().contains(HGQuery.hg.anyHandle())) {
                lc.getTargetSet().remove(HGQuery.hg.anyHandle());
                lc.getTargetSet().add(this.graph.getHandleFactory().anyHandle());
            }
        } else if (c instanceof OrderedLinkCondition) {
            OrderedLinkCondition lc = (OrderedLinkCondition)c;
            for (int i = 0; i < lc.getTargets().length; ++i) {
                if (lc.getTargets()[i] != HGQuery.hg.anyHandle()) continue;
                lc.getTargets()[i] = this.graph.getHandleFactory().anyHandle();
            }
        } else if (c instanceof Not) {
            if (((Not)c).getPredicate() instanceof HGQueryCondition) {
                this.preprocess((HGQueryCondition)((Object)((Not)c).getPredicate()));
            }
        } else if (c instanceof And) {
            for (HGQueryCondition sub : (And)c) {
                this.preprocess(sub);
            }
        } else if (c instanceof Or) {
            for (HGQueryCondition sub : (Or)c) {
                this.preprocess(sub);
            }
        } else if (c instanceof MapCondition) {
            this.preprocess(((MapCondition)c).getCondition());
        }
    }

    public ExpressionBasedQuery(final HyperGraph graph, final HGQueryCondition condition) {
        this.graph = graph;
        this.preprocess(condition);
        this.condition = graph.getTransactionManager().ensureTransaction(new Callable<HGQueryCondition>(){

            @Override
            public HGQueryCondition call() {
                return ExpressionBasedQuery.this.simplify(ExpressionBasedQuery.toDNF(ExpressionBasedQuery.this.expand(graph, condition)));
            }
        });
        this.query = ToQueryMap.toQuery(graph, this.condition);
    }

    @Override
    public HGSearchResult<ResultType> execute() {
        return this.query.execute();
    }

    public HGQueryCondition getCondition() {
        return this.condition;
    }

    public HGQuery getCompiledQuery() {
        return this.query;
    }
}

