/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.query;

import java.util.ArrayList;
import java.util.List;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.algorithms.DefaultALGenerator;
import org.hypergraphdb.algorithms.HGDepthFirstTraversal;
import org.hypergraphdb.atom.HGSubsumes;
import org.hypergraphdb.query.AtomTypeCondition;
import org.hypergraphdb.query.HGAtomPredicate;
import org.hypergraphdb.query.HGQueryCondition;
import org.hypergraphdb.util.HGUtils;
import org.hypergraphdb.util.Pair;

public class TypePlusCondition
implements HGQueryCondition,
HGAtomPredicate {
    private Class<?> clazz;
    private HGHandle baseType;
    private List<HGHandle> subTypes = null;

    private void fetchSubTypes(HyperGraph graph) {
        if (this.baseType == null) {
            this.baseType = graph.getTypeSystem().getTypeHandle(this.clazz);
        }
        DefaultALGenerator alGenerator = new DefaultALGenerator(graph, new AtomTypeCondition(HGSubsumes.class), null, false, true, false);
        HGDepthFirstTraversal traversal = new HGDepthFirstTraversal(this.baseType, alGenerator);
        this.subTypes = new ArrayList<HGHandle>();
        while (traversal.hasNext()) {
            this.subTypes.add((HGHandle)((Pair)traversal.next()).getSecond());
        }
        this.subTypes.add(this.baseType);
    }

    public TypePlusCondition() {
    }

    public TypePlusCondition(HGHandle baseType) {
        this.baseType = baseType;
        if (baseType == null) {
            throw new NullPointerException("Base type is null in TypePlusCondition!");
        }
    }

    public TypePlusCondition(Class<?> clazz) {
        this.clazz = clazz;
        if (clazz == null) {
            throw new NullPointerException("Base type is null in TypePlusCondition!");
        }
    }

    @Override
    public boolean satisfies(HyperGraph graph, HGHandle handle) {
        for (HGHandle t : this.getSubTypes(graph)) {
            if (!graph.getType(handle).equals(t)) continue;
            return true;
        }
        return false;
    }

    public void setBaseType(HGHandle baseType) {
        this.baseType = baseType;
    }

    public HGHandle getBaseType() {
        return this.baseType;
    }

    public void setJavaClass(Class<?> javaClass) {
        this.clazz = javaClass;
    }

    public Class<?> getJavaClass() {
        return this.clazz;
    }

    public List<HGHandle> getSubTypes(HyperGraph graph) {
        if (this.subTypes == null) {
            this.fetchSubTypes(graph);
        }
        return this.subTypes;
    }

    public int hashCode() {
        return this.clazz == null ? this.baseType.hashCode() : this.clazz.hashCode();
    }

    public boolean equals(Object x) {
        if (!(x instanceof TypePlusCondition)) {
            return false;
        }
        TypePlusCondition c = (TypePlusCondition)x;
        return this.clazz == null ? HGUtils.eq(this.baseType, c.baseType) : HGUtils.eq(this.clazz, c.clazz);
    }
}

