/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.query;

import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.query.HGAtomPredicate;
import org.hypergraphdb.query.HGQueryCondition;
import org.hypergraphdb.query.SubsumesImpl;
import org.hypergraphdb.type.HGAtomType;

public class SubsumesCondition
extends SubsumesImpl
implements HGQueryCondition,
HGAtomPredicate {
    private HGHandle specific;
    private Object specificValue;
    private HGAtomPredicate impl;

    public SubsumesCondition() {
    }

    public SubsumesCondition(Object specificValue) {
        this.setSpecificValue(specificValue);
    }

    public SubsumesCondition(HGHandle specific) {
        this.setSpecificHandle(specific);
    }

    public HGHandle getSpecificHandle() {
        return this.specific;
    }

    public void setSpecificHandle(HGHandle specific) {
        this.specific = specific;
        if (this.specific != null) {
            this.impl = new HandleBased();
        }
    }

    public Object getSpecificValue() {
        return this.specificValue;
    }

    public void setSpecificValue(Object specificValue) {
        this.specificValue = specificValue;
        if (this.specificValue != null) {
            this.impl = new AtomBased();
        }
    }

    @Override
    public final boolean satisfies(HyperGraph hg2, HGHandle general) {
        return this.impl.satisfies(hg2, general);
    }

    public int hashCode() {
        return this.specific != null ? this.specific.hashCode() : this.specificValue.hashCode();
    }

    public boolean equals(Object x) {
        if (!(x instanceof SubsumesCondition)) {
            return false;
        }
        SubsumesCondition c = (SubsumesCondition)x;
        return this.specific.equals(c.specific);
    }

    private final class HandleBased
    implements HGAtomPredicate {
        private HandleBased() {
        }

        @Override
        public boolean satisfies(HyperGraph graph, HGHandle general) {
            if (SubsumesCondition.this.declaredSubsumption(graph, general, SubsumesCondition.this.specific)) {
                return true;
            }
            HGHandle specificType = graph.getType(SubsumesCondition.this.specific);
            HGHandle generalType = graph.getType(general);
            if (!generalType.equals(specificType)) {
                return false;
            }
            return ((HGAtomType)graph.get(generalType)).subsumes(graph.get(general), graph.get(SubsumesCondition.this.specific));
        }
    }

    private final class AtomBased
    implements HGAtomPredicate {
        private AtomBased() {
        }

        @Override
        public boolean satisfies(HyperGraph graph, HGHandle general) {
            HGHandle specificType;
            HGHandle generalType = graph.getType(general);
            if (SubsumesCondition.this.specificValue == null) {
                return ((HGAtomType)graph.get(graph.getType(general))).subsumes(graph.get(general), null);
            }
            HGHandle h = graph.getHandle(SubsumesCondition.this.specificValue);
            if (h == null) {
                specificType = graph.getTypeSystem().getTypeHandle(SubsumesCondition.this.specificValue.getClass());
            } else {
                specificType = graph.getType(h);
                if (SubsumesCondition.this.declaredSubsumption(graph, general, h)) {
                    return true;
                }
            }
            if (!specificType.equals(generalType)) {
                return false;
            }
            return ((HGAtomType)graph.get(graph.getType(general))).subsumes(graph.get(general), SubsumesCondition.this.specificValue);
        }
    }
}

