/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.query;

import org.hypergraphdb.HGException;
import org.hypergraphdb.HGValueLink;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.query.ComparisonOperator;
import org.hypergraphdb.query.HGAtomPredicate;
import org.hypergraphdb.query.HGQueryCondition;
import org.hypergraphdb.util.HGUtils;

public abstract class SimpleValueCondition
implements HGQueryCondition,
HGAtomPredicate {
    protected Object value;
    protected ComparisonOperator operator;

    protected boolean compareToValue(HyperGraph graph, Object x) {
        if (x instanceof HGValueLink) {
            x = ((HGValueLink)x).getValue();
        }
        switch (this.operator) {
            case EQ: {
                return this.value.equals(x);
            }
            case LT: {
                return ((Comparable)x).compareTo(this.value) < 0;
            }
            case GT: {
                return ((Comparable)x).compareTo(this.value) > 0;
            }
            case LTE: {
                return ((Comparable)x).compareTo(this.value) <= 0;
            }
            case GTE: {
                return ((Comparable)x).compareTo(this.value) >= 0;
            }
        }
        throw new HGException("Wrong operator code [" + (Object)((Object)this.operator) + "] passed to SimpleValueCondition.");
    }

    public SimpleValueCondition() {
    }

    public SimpleValueCondition(Object value) {
        this.value = value;
        this.operator = ComparisonOperator.EQ;
    }

    public SimpleValueCondition(Object value, ComparisonOperator operator) {
        this.value = value;
        this.operator = operator;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public ComparisonOperator getOperator() {
        return this.operator;
    }

    public void setOperator(ComparisonOperator operator) {
        this.operator = operator;
    }

    public int hashCode() {
        return HGUtils.hashIt(this.value);
    }

    public boolean equals(Object x) {
        if (!(x instanceof SimpleValueCondition)) {
            return false;
        }
        SimpleValueCondition y = (SimpleValueCondition)x;
        return HGUtils.eq(this.value, y.value) && this.operator.equals((Object)y.operator);
    }
}

