/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.query;

import java.util.List;
import org.hypergraphdb.HGException;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGLink;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.handle.HGLiveHandle;
import org.hypergraphdb.query.HGAtomPredicate;
import org.hypergraphdb.query.HGQueryCondition;
import org.hypergraphdb.util.HGUtils;

public class OrderedLinkCondition
implements HGQueryCondition,
HGAtomPredicate {
    private HGHandle[] targetSet = HyperGraph.EMTPY_HANDLE_SET;
    private byte[] targetsBuffer = null;

    public OrderedLinkCondition() {
    }

    public OrderedLinkCondition(HGHandle[] targetSet) {
        if (targetSet == null) {
            throw new HGException("OrderedLinkCondition instantiated with a null target set.");
        }
        this.targetSet = new HGHandle[targetSet.length];
        System.arraycopy(targetSet, 0, this.targetSet, 0, targetSet.length);
    }

    public OrderedLinkCondition(List<HGHandle> targetSet) {
        if (targetSet == null) {
            throw new HGException("OrderedLinkCondition instantiated with a null target set.");
        }
        this.targetSet = new HGHandle[targetSet.size()];
        int i = 0;
        for (HGHandle h : targetSet) {
            this.targetSet[i++] = h;
        }
    }

    public HGHandle[] targets() {
        return this.targetSet;
    }

    public HGHandle[] getTargets() {
        return this.targetSet;
    }

    public void setTargets(HGHandle[] targetSet) {
        this.targetSet = targetSet;
    }

    public void setTarget(int pos, HGHandle newTarget) {
        this.targetSet[pos] = newTarget;
        byte[] B = newTarget instanceof HGPersistentHandle ? ((HGPersistentHandle)newTarget).toByteArray() : ((HGLiveHandle)newTarget).getPersistentHandle().toByteArray();
        if (this.targetsBuffer != null) {
            System.arraycopy(B, 0, this.targetsBuffer, B.length * pos, B.length);
        }
    }

    @Override
    public boolean satisfies(HyperGraph hg2, HGHandle handle) {
        if (hg2.isLoaded(handle)) {
            Object atom = hg2.get(handle);
            if (!(atom instanceof HGLink)) {
                return false;
            }
            HGLink link = (HGLink)atom;
            int j = 0;
            for (int i = 0; i < link.getArity() && j < this.targetSet.length; ++i) {
                if (!this.targetSet[j].equals(link.getTargetAt(i))) continue;
                ++j;
            }
            return j == this.targetSet.length;
        }
        HGPersistentHandle[] A = hg2.getStore().getLink(hg2.getPersistentHandle(handle));
        int j = 0;
        for (int i = 2; i < A.length && j < this.targetSet.length; ++i) {
            if (!this.targetSet[j].equals(A[i]) && !this.targetSet[j].equals(hg2.getHandleFactory().anyHandle())) continue;
            ++j;
        }
        return j == this.targetSet.length;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("orderedLinks(");
        for (int i = 0; i < this.targetSet.length; ++i) {
            result.append(this.targetSet[i]);
            if (i >= this.targetSet.length - 1) continue;
            result.append(",");
        }
        result.append(")");
        return result.toString();
    }

    public int hashCode() {
        int x = 0;
        for (HGHandle h : this.targetSet) {
            x += h.hashCode();
        }
        return x;
    }

    public boolean equals(Object x) {
        if (!(x instanceof OrderedLinkCondition)) {
            return false;
        }
        return HGUtils.eq(this.targetSet, ((OrderedLinkCondition)x).targetSet);
    }
}

