/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.query;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.hypergraphdb.HGException;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGLink;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.query.HGAtomPredicate;
import org.hypergraphdb.query.HGQueryCondition;

public class LinkCondition
implements HGQueryCondition,
HGAtomPredicate {
    private HashSet<HGHandle> targetSet = null;

    public LinkCondition() {
    }

    public LinkCondition(HGLink link) {
        this.targetSet = new HashSet();
        for (int i = 0; i < link.getArity(); ++i) {
            this.targetSet.add(link.getTargetAt(i));
        }
    }

    public LinkCondition(HGHandle[] targets) {
        if (targets == null) {
            throw new HGException("LinkCondition instantiated with a null target set.");
        }
        this.targetSet = new HashSet();
        for (int i = 0; i < targets.length; ++i) {
            this.targetSet.add(targets[i]);
        }
    }

    public LinkCondition(Collection<HGHandle> targets) {
        if (targets == null) {
            throw new HGException("LinkCondition instantiated with a null target set.");
        }
        this.targetSet = new HashSet();
        this.targetSet.addAll(targets);
    }

    public HashSet<HGHandle> targets() {
        return this.targetSet;
    }

    public HashSet<HGHandle> getTargetSet() {
        return this.targetSet;
    }

    public void setTargetSet(HashSet<HGHandle> targetSet) {
        this.targetSet = targetSet;
    }

    @Override
    public boolean satisfies(HyperGraph hg2, HGHandle handle) {
        int count = 0;
        if (hg2.isLoaded(handle)) {
            Object atom = hg2.get(handle);
            if (!(atom instanceof HGLink)) {
                return false;
            }
            HGLink link = (HGLink)atom;
            for (int i = 0; i < link.getArity(); ++i) {
                if (!this.targetSet.contains(link.getTargetAt(i))) continue;
                ++count;
            }
        } else {
            HGPersistentHandle[] A = hg2.getStore().getLink(hg2.getPersistentHandle(handle));
            for (int i = 2; i < A.length; ++i) {
                if (!this.targetSet.contains(A[i])) continue;
                ++count;
            }
        }
        return count == this.targetSet.size();
    }

    public int hashCode() {
        return this.targetSet.hashCode();
    }

    public boolean equals(Object x) {
        if (!(x instanceof LinkCondition)) {
            return false;
        }
        return ((LinkCondition)x).targetSet.equals(this.targetSet);
    }

    public String toString() {
        StringBuffer result = new StringBuffer("links(");
        Iterator<HGHandle> i = this.targetSet.iterator();
        while (i.hasNext()) {
            result.append(i.next().toString());
            if (!i.hasNext()) continue;
            result.append(",");
        }
        result.append(")");
        return result.toString();
    }
}

