/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.peer.workflow;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.hypergraphdb.peer.workflow.StateListener;
import org.hypergraphdb.peer.workflow.WorkflowStateConstant;

public class WorkflowState {
    private static Map<String, WorkflowStateConstant> constantPool = new IdentityHashMap<String, WorkflowStateConstant>();
    public static final WorkflowStateConstant Limbo = WorkflowState.makeStateConstant("Limbo");
    public static final WorkflowStateConstant Started = WorkflowState.makeStateConstant("Started");
    public static final WorkflowStateConstant Completed = WorkflowState.makeStateConstant("Completed");
    public static final WorkflowStateConstant Failed = WorkflowState.makeStateConstant("Failed");
    public static final WorkflowStateConstant Canceled = WorkflowState.makeStateConstant("Canceled");
    protected AtomicReference<String> name = new AtomicReference<String>("Limbo".intern());
    protected List<StateListener> listeners = null;

    private String validateStateChange(WorkflowState s) {
        if (WorkflowState.Limbo.name.get() == s.name.get()) {
            return null;
        }
        String c = this.name.get();
        if (WorkflowState.Completed.name.get() != c && WorkflowState.Failed.name.get() != c && WorkflowState.Canceled.name.get() != c) {
            return c;
        }
        return null;
    }

    protected WorkflowState(String name) {
        this.name.set(name);
        this.listeners = new ArrayList<StateListener>(1);
    }

    public static synchronized WorkflowStateConstant makeStateConstant(String name) {
        String interned = name.intern();
        WorkflowStateConstant result = constantPool.get(interned);
        if (result == null) {
            result = new WorkflowStateConstant(interned);
            constantPool.put(interned, result);
        }
        return result;
    }

    public static synchronized WorkflowStateConstant toStateConstant(String name) {
        WorkflowStateConstant c = constantPool.get(name.intern());
        if (c == null) {
            throw new RuntimeException("Unknown state constant: " + name);
        }
        return c;
    }

    public static WorkflowState makeState(WorkflowStateConstant stateConstant) {
        return new WorkflowState((String)stateConstant.name.get());
    }

    public static WorkflowState makeState() {
        return WorkflowState.makeState(Limbo);
    }

    public WorkflowStateConstant getConst() {
        return constantPool.get(this.name.get());
    }

    public boolean compareAndAssign(WorkflowStateConstant oldState, WorkflowStateConstant newState) {
        if (newState == Limbo || oldState == Failed || oldState == Completed || oldState == Canceled) {
            throw new IllegalArgumentException("Invalid state change to " + (String)newState.name.get() + " from " + (String)oldState.name.get());
        }
        if (this.name.compareAndSet((String)oldState.name.get(), (String)newState.name.get())) {
            for (StateListener l : this.listeners) {
                l.stateChanged(this);
            }
            return true;
        }
        return false;
    }

    public void assign(WorkflowStateConstant newState) {
        String s = this.validateStateChange(newState);
        if (s == null) {
            throw new IllegalArgumentException("Invalid state change to " + (String)newState.name.get() + " while current is " + this.toString());
        }
        if (this.name.compareAndSet(s, (String)newState.name.get())) {
            for (StateListener l : this.listeners) {
                l.stateChanged(this);
            }
        } else {
            throw new ConcurrentModificationException("Concurrent state change to " + (String)newState.name.get() + " from " + this.name.get() + " which changed recently from " + s);
        }
    }

    public void addListener(StateListener l) {
        this.listeners.add(l);
    }

    public void removeListener(StateListener l) {
        this.listeners.remove(l);
    }

    public boolean isInLimbo() {
        return this.name.get() == WorkflowState.Limbo.name.get();
    }

    public boolean isStarted() {
        return !this.isInLimbo() && !this.isFinished();
    }

    public void setStarted() {
        this.assign(Started);
    }

    public boolean isCompleted() {
        return this.name.get() == WorkflowState.Completed.name.get();
    }

    public void setCompleted() {
        this.assign(Completed);
    }

    public boolean isFailed() {
        return this.name.get() == WorkflowState.Failed.name.get();
    }

    public void setFailed() {
        this.assign(Failed);
    }

    public boolean isCanceled() {
        return this.name.get() == WorkflowState.Canceled.name.get();
    }

    public void setCanceled() {
        this.assign(Canceled);
    }

    public boolean isFinished() {
        return this.isCompleted() || this.isFailed() || this.isCanceled();
    }

    public int hashCode() {
        return this.name.get().hashCode();
    }

    public boolean equals(Object x) {
        if (x instanceof WorkflowState) {
            return this.name.get() == ((WorkflowState)x).name.get();
        }
        return false;
    }

    public String toString() {
        return this.name.get();
    }
}

