/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.peer.workflow;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import org.hypergraphdb.peer.HyperGraphPeer;
import org.hypergraphdb.peer.Message;
import org.hypergraphdb.peer.PeerInterface;
import org.hypergraphdb.peer.Structs;
import org.hypergraphdb.peer.workflow.AbstractActivity;
import org.hypergraphdb.peer.workflow.ActivityStateListener;
import org.hypergraphdb.peer.workflow.Conversation;
import org.hypergraphdb.util.Pair;

public abstract class TaskActivity<StateType>
extends AbstractActivity<StateType>
implements ActivityStateListener {
    private UUID taskId;
    private HyperGraphPeer thisPeer;
    private HashMap<UUID, Conversation<?>> conversations = new HashMap();
    private HashMap<StateType, LinkedBlockingQueue<AbstractActivity<?>>> activityQueues = new HashMap();
    private HashMap<Object, StateType> conversationQueueMaping = new HashMap();
    private HashMap<Pair<StateType, Object>, Pair<StateType, Method>> transitions = new HashMap();
    private HashSet<Object> conversationStates = new HashSet();

    public TaskActivity(HyperGraphPeer thisPeer, StateType start, StateType end) {
        this(thisPeer, UUID.randomUUID(), start, end);
    }

    public TaskActivity(HyperGraphPeer thisPeer, UUID taskId, StateType start, StateType end) {
        super(start, end);
        this.thisPeer = thisPeer;
        this.taskId = taskId;
    }

    protected void sendReply(Object originalMsg, Message reply) {
        this.getPeerInterface().send(Structs.getPart(originalMsg, "reply-to"), reply);
    }

    protected void handleActivity(Method method, AbstractActivity<?> activity) {
        try {
            Object targetState = method.invoke((Object)this, activity);
            this.setState(targetState);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void stateChanged(Object newState, AbstractActivity<?> activity) {
        System.out.println("TaskActivity: conversation state changed to " + newState + " while in " + this.getState());
        StateType interestedState = this.conversationQueueMaping.get(newState);
        LinkedBlockingQueue<AbstractActivity<?>> queue = this.activityQueues.get(interestedState);
        if (queue != null) {
            try {
                System.out.println("queueing message for " + interestedState);
                queue.put(activity);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("can not find queue for " + interestedState);
        }
    }

    public void handleMessage(Message msg) {
        System.out.println("TaskActivity: handleMessage ");
        Conversation<?> conversation = null;
        UUID conversationId = (UUID)Structs.getPart(msg, "conversation-id");
        if (conversationId != null) {
            conversation = this.conversations.get(conversationId);
        }
        if (conversation == null && (conversation = this.createNewConversation(msg)) != null) {
            conversation.setId(conversationId == null ? UUID.randomUUID() : conversationId);
            this.registerConversation(conversation, conversationId);
        }
        if (conversation != null) {
            conversation.handleIncomingMessage(msg);
        }
    }

    @Override
    protected void initiate() {
    }

    @Override
    protected void doRun() {
        this.compareAndSetState(null, this.startState);
        while (!this.isStopped()) {
            LinkedBlockingQueue<AbstractActivity<?>> queue = this.activityQueues.get(this.getState());
            if (queue != null) {
                AbstractActivity<?> activity = null;
                try {
                    System.out.println("wating on queue for " + this.getState());
                    activity = queue.take();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (activity == null) continue;
                Pair<StateType, Method> dest = this.transitions.get(new Pair(this.getState(), activity.getState()));
                if (!this.compareAndSetState(this.getState(), dest.getFirst())) continue;
                this.handleActivity(dest.getSecond(), activity);
                continue;
            }
            System.out.println("No queue found for " + this.getState() + " in " + this.getClass());
            try {
                this.stateChangedLatch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    protected void registerConversation(Conversation<?> conversation, UUID conversationId) {
        if (conversation != null) {
            for (Object conversationState : this.conversationStates) {
                conversation.setStateListener(conversationState, this);
            }
            this.conversations.put(conversationId, conversation);
        }
    }

    protected Conversation<?> createNewConversation(Message msg) {
        return null;
    }

    protected void registerConversationHandler(StateType fromState, Object conversationState, String functionName, StateType toState) {
        if (!this.activityQueues.containsKey(fromState)) {
            LinkedBlockingQueue queue = new LinkedBlockingQueue();
            this.activityQueues.put(fromState, queue);
        }
        try {
            Method method = this.getClass().getMethod(functionName, AbstractActivity.class);
            this.transitions.put(new Pair<StateType, Object>(fromState, conversationState), new Pair<StateType, Method>(toState, method));
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        this.conversationQueueMaping.put(conversationState, fromState);
        this.conversationStates.add(conversationState);
    }

    public UUID getTaskId() {
        return this.taskId;
    }

    public void setTaskId(UUID taskId) {
        this.taskId = taskId;
    }

    public HyperGraphPeer getThisPeer() {
        return this.thisPeer;
    }

    public PeerInterface getPeerInterface() {
        return this.thisPeer.getPeerInterface();
    }
}

