/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.peer.workflow;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.peer.HyperGraphPeer;
import org.hypergraphdb.peer.Message;
import org.hypergraphdb.peer.Messages;
import org.hypergraphdb.peer.PeerFilter;
import org.hypergraphdb.peer.PeerFilterEvaluator;
import org.hypergraphdb.peer.PeerRelatedActivity;
import org.hypergraphdb.peer.PeerRelatedActivityFactory;
import org.hypergraphdb.peer.Performative;
import org.hypergraphdb.peer.Structs;
import org.hypergraphdb.peer.SubgraphManager;
import org.hypergraphdb.peer.workflow.Activity;
import org.hypergraphdb.peer.workflow.WorkflowState;
import org.hypergraphdb.query.HGQueryCondition;
import org.hypergraphdb.storage.StorageGraph;

public class QueryTaskClient
extends Activity {
    private AtomicInteger count = new AtomicInteger(1);
    private PeerFilterEvaluator evaluator = null;
    private Iterator<Object> targets = null;
    private HGHandle handle;
    private HGQueryCondition cond;
    private boolean getObject;
    private HyperGraph tempGraph;
    private ArrayList<Object> result;

    public QueryTaskClient(HyperGraphPeer thisPeer, HyperGraph tempGraph) {
        super(thisPeer);
        this.tempGraph = tempGraph;
    }

    public QueryTaskClient(HyperGraphPeer thisPeer, HyperGraph tempGraph, PeerFilterEvaluator evaluator, HGQueryCondition cond, boolean getObject) {
        super(thisPeer);
        this.evaluator = evaluator;
        this.handle = null;
        this.cond = cond;
        this.getObject = getObject;
        this.tempGraph = tempGraph;
    }

    public QueryTaskClient(HyperGraphPeer thisPeer, HyperGraph tempGraph, Iterator<Object> targets, HGQueryCondition cond, boolean getObject) {
        super(thisPeer);
        this.targets = targets;
        this.handle = null;
        this.cond = cond;
        this.getObject = getObject;
        this.tempGraph = tempGraph;
    }

    public QueryTaskClient(HyperGraphPeer thisPeer, HyperGraph tempGraph, PeerFilterEvaluator evaluator, HGHandle handle) {
        super(thisPeer);
        this.evaluator = evaluator;
        this.handle = handle;
        this.getObject = true;
        this.tempGraph = tempGraph;
    }

    public QueryTaskClient(HyperGraphPeer thisPeer, HyperGraph tempGraph, Iterator<Object> targets, HGHandle handle) {
        super(thisPeer);
        this.targets = targets;
        this.handle = handle;
        this.getObject = true;
        this.tempGraph = tempGraph;
    }

    private Iterator<Object> getTargets() {
        if (this.targets != null) {
            return this.targets;
        }
        PeerFilter peerFilter = this.getPeerInterface().newFilterActivity(this.evaluator);
        peerFilter.filterTargets();
        return peerFilter.iterator();
    }

    @Override
    public void initiate() {
        PeerRelatedActivityFactory activityFactory = this.getPeerInterface().newSendActivityFactory();
        Iterator<Object> it = this.getTargets();
        while (it.hasNext()) {
            Object target = it.next();
            this.sendMessage(activityFactory, target);
        }
        if (this.count.decrementAndGet() == 0) {
            this.getState().assign(WorkflowState.Completed);
        }
    }

    private void sendMessage(PeerRelatedActivityFactory activityFactory, Object target) {
        this.count.incrementAndGet();
        Message msg = Messages.createMessage(Performative.Request, "query", this.getId());
        Structs.combine(msg, Structs.struct("content", Structs.struct("query", this.handle == null ? this.cond : this.handle, "getObj", this.getObject)));
        PeerRelatedActivity activity = activityFactory.createActivity();
        activity.setTarget(target);
        activity.setMessage(msg);
        this.getThisPeer().getExecutorService().submit(activity);
    }

    @Override
    public void handleMessage(Message msg) {
        ArrayList reply = (ArrayList)Structs.getPart(msg, "content");
        this.result = new ArrayList();
        for (int i = 0; i < reply.size(); ++i) {
            Object elem = Structs.getPart(reply, i);
            if (elem instanceof StorageGraph) {
                this.result.add(SubgraphManager.get((StorageGraph)elem, this.tempGraph));
                continue;
            }
            this.result.add(elem);
        }
        if (this.count.decrementAndGet() == 0) {
            this.getState().assign(WorkflowState.Completed);
        }
    }

    public ArrayList<Object> getResult() {
        return this.result;
    }

    public void setResult(ArrayList<Object> result) {
        this.result = result;
    }
}

