/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.peer.workflow;

import java.util.UUID;
import org.hypergraphdb.peer.ExceptionAtPeer;
import org.hypergraphdb.peer.HGPeerIdentity;
import org.hypergraphdb.peer.HyperGraphPeer;
import org.hypergraphdb.peer.Message;
import org.hypergraphdb.peer.Messages;
import org.hypergraphdb.peer.Structs;
import org.hypergraphdb.peer.workflow.Activity;
import org.hypergraphdb.peer.workflow.WorkflowState;

public abstract class FSMActivity
extends Activity {
    protected void onPeerFailure(Message msg) {
        HGPeerIdentity id = this.getThisPeer().getIdentity(Messages.getSender(msg));
        this.future.result.exception = new ExceptionAtPeer(id, (String)Structs.getPart(msg, "content"));
        this.getState().assign(WorkflowState.Failed);
    }

    protected void onPeerNotUnderstand(Message msg) {
        HGPeerIdentity id = this.getThisPeer().getIdentity(Messages.getSender(msg));
        this.future.result.exception = new ExceptionAtPeer(id, "Peer did not understand last message:" + Structs.getPart(msg, "content"));
        this.getState().assign(WorkflowState.Failed);
    }

    public FSMActivity(HyperGraphPeer thisPeer) {
        super(thisPeer);
    }

    public FSMActivity(HyperGraphPeer thisPeer, UUID id) {
        super(thisPeer, id);
    }

    @Override
    public void initiate() {
    }

    @Override
    public final void handleMessage(Message message) {
    }
}

