/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.peer.workflow;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.hypergraphdb.peer.Message;
import org.hypergraphdb.peer.Performative;
import org.hypergraphdb.peer.Structs;
import org.hypergraphdb.peer.workflow.AbstractActivity;
import org.hypergraphdb.peer.workflow.TaskActivity;
import org.hypergraphdb.util.Pair;

public class Conversation<StateType>
extends AbstractActivity<StateType> {
    private UUID id;
    private TaskActivity<?> task;
    private Object peer;
    private Message msg;
    private Map<Pair<StateType, Performative>, StateType> performativeTransitions = new HashMap<Pair<StateType, Performative>, StateType>();

    public Conversation(TaskActivity<?> task, Object peer, StateType start, StateType end) {
        super(start, end);
        this.task = task;
        this.peer = peer;
    }

    @Override
    protected void initiate() {
    }

    @Override
    protected void doRun() {
    }

    protected void registerPerformativeTransition(StateType fromState, Performative performative, StateType toState) {
        this.performativeTransitions.put(new Pair<StateType, Performative>(fromState, performative), toState);
    }

    public void handleIncomingMessage(Message msg) {
        this.compareAndSetState(null, this.startState);
        Object state = this.getState();
        Object x = Structs.getPart(msg, "performative");
        Pair key = new Pair(state, Performative.toConstant(x.toString()));
        StateType newState = this.performativeTransitions.get(key);
        if (newState != null && this.compareAndSetState(state, newState)) {
            this.msg = msg;
        }
    }

    protected void say(Message msg) {
        Structs.combine(msg, Structs.struct("conversation-id", this.getId()));
        this.task.getPeerInterface().send(this.peer, msg);
    }

    public Message getMessage() {
        return this.msg;
    }

    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }
}

