/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.peer.workflow;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.peer.HGPeerIdentity;
import org.hypergraphdb.peer.HyperGraphPeer;
import org.hypergraphdb.peer.Message;
import org.hypergraphdb.peer.Messages;
import org.hypergraphdb.peer.Performative;
import org.hypergraphdb.peer.Structs;
import org.hypergraphdb.peer.workflow.FSMActivity;
import org.hypergraphdb.peer.workflow.FromState;
import org.hypergraphdb.peer.workflow.OnMessage;
import org.hypergraphdb.peer.workflow.PossibleOutcome;
import org.hypergraphdb.peer.workflow.WorkflowState;

public class AffirmIdentity
extends FSMActivity {
    public static final String TYPE_NAME = "affirm-identity";
    Object target = null;
    AtomicInteger count = null;

    Object makeIdentityStruct(HGPeerIdentity identity) {
        return Structs.struct("uuid", identity.getId(), "hostname", identity.getHostname(), "ipaddress", identity.getIpAddress(), "graph-location", identity.getGraphLocation(), "name", identity.getName());
    }

    HGPeerIdentity parseIdentity(Map<String, Object> S) {
        HGPeerIdentity I = new HGPeerIdentity();
        I.setId((HGPersistentHandle)Structs.getPart(S, "uuid"));
        I.setHostname(S.get("hostname").toString());
        I.setIpAddress(S.get("ipaddress").toString());
        I.setGraphLocation(S.get("graph-location").toString());
        I.setName(S.get("name").toString());
        return I;
    }

    public AffirmIdentity(HyperGraphPeer thisPeer) {
        this(thisPeer, null);
    }

    public AffirmIdentity(HyperGraphPeer thisPeer, UUID id) {
        super(thisPeer, id);
    }

    public AffirmIdentity(HyperGraphPeer thisPeer, Object target) {
        super(thisPeer, UUID.randomUUID());
        this.target = target;
    }

    @Override
    public String getType() {
        return TYPE_NAME;
    }

    @Override
    public void initiate() {
        Map<String, Object> inform = Structs.combine(Messages.createMessage(Performative.Inform, this), Structs.struct("content", this.makeIdentityStruct(this.getThisPeer().getIdentity())));
        if (this.target == null) {
            this.getPeerInterface().broadcast((Message)inform);
        } else {
            this.getPeerInterface().send(this.target, (Message)inform);
        }
    }

    @FromState(value={"Started"})
    @OnMessage(performative="Inform")
    @PossibleOutcome(value={"Completed"})
    public WorkflowState onInform(Message msg) {
        HGPeerIdentity thisId = this.getThisPeer().getIdentity();
        HGPeerIdentity id = this.parseIdentity(Structs.getStruct(msg, "content"));
        Message reply = Messages.getReply(msg);
        if (id.getId().equals(thisId.getId())) {
            Structs.combine(reply, Structs.struct("performative", Performative.Disconfirm));
        } else {
            Structs.combine(reply, Structs.combine(Structs.struct("performative", Performative.Confirm), Structs.struct("content", this.makeIdentityStruct(this.getThisPeer().getIdentity()))));
            this.getThisPeer().bindIdentityToNetworkTarget(id, Structs.getPart(msg, "reply-to"));
        }
        this.getPeerInterface().send(Messages.getSender(msg), reply);
        return WorkflowState.Completed;
    }

    @FromState(value={"Started"})
    @OnMessage(performative="Confirm")
    @PossibleOutcome(value={"Completed"})
    public WorkflowState onConfirm(Message msg) {
        HGPeerIdentity id = this.parseIdentity(Structs.getStruct(msg, "content"));
        this.getThisPeer().bindIdentityToNetworkTarget(id, Structs.getPart(msg, "reply-to"));
        return WorkflowState.Completed;
    }

    @FromState(value={"Started"})
    @OnMessage(performative="Disconfirm")
    @PossibleOutcome(value={"Failed"})
    public WorkflowState onDisconfirm(Message msg) {
        return WorkflowState.Failed;
    }
}

