/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.peer.workflow;

import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import org.hypergraphdb.peer.HGPeerIdentity;
import org.hypergraphdb.peer.HyperGraphPeer;
import org.hypergraphdb.peer.Message;
import org.hypergraphdb.peer.Messages;
import org.hypergraphdb.peer.PeerInterface;
import org.hypergraphdb.peer.Performative;
import org.hypergraphdb.peer.workflow.ActivityManager;
import org.hypergraphdb.peer.workflow.ActivityResult;
import org.hypergraphdb.peer.workflow.WorkflowState;
import org.hypergraphdb.util.HGUtils;

public abstract class Activity {
    volatile BlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
    volatile long lastActionTimestamp = 0L;
    volatile ActivityManager.ActivityFuture future;
    private UUID id = null;
    private HyperGraphPeer thisPeer;
    private WorkflowState state = WorkflowState.makeState();

    public HyperGraphPeer getThisPeer() {
        return this.thisPeer;
    }

    protected PeerInterface getPeerInterface() {
        return this.thisPeer.getPeerInterface();
    }

    protected void send(HGPeerIdentity target, Message msg) {
        Object networkTarget = this.thisPeer.getNetworkTarget(target);
        if (networkTarget == null) {
            throw new RuntimeException("Unknown network target for peer " + target + " - perhaps it dropped from the network?");
        }
        try {
            if (!this.getPeerInterface().send(networkTarget, msg).get().booleanValue()) {
                throw new RuntimeException("Failed to send msg '" + msg + "' to " + target);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected Future<Boolean> post(HGPeerIdentity target, Message msg) {
        Object networkTarget = this.thisPeer.getNetworkTarget(target);
        if (networkTarget == null) {
            throw new RuntimeException("Unknown network target for peer " + target + " - perhaps it dropped from the network?");
        }
        try {
            return this.getPeerInterface().send(networkTarget, msg);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void send(Object target, Message msg) {
        if (target instanceof HGPeerIdentity) {
            this.send((HGPeerIdentity)target, msg);
        } else {
            this.getPeerInterface().send(target, msg);
        }
    }

    protected Future<Boolean> post(Object target, Message msg) {
        if (target instanceof HGPeerIdentity) {
            return this.post((HGPeerIdentity)target, msg);
        }
        return this.getPeerInterface().send(target, msg);
    }

    protected Future<Boolean> reply(Message msg, Performative perf, Object content) {
        return this.post(Messages.getSender(msg), Messages.getReply(msg, perf, content));
    }

    protected void addAction(Runnable action) throws InterruptedException {
        if (action == null) {
            return;
        }
        this.queue.put(action);
    }

    public Activity(HyperGraphPeer thisPeer) {
        this.thisPeer = thisPeer;
        this.id = UUID.randomUUID();
    }

    public Activity(HyperGraphPeer thisPeer, UUID id) {
        this.thisPeer = thisPeer;
        this.id = id;
    }

    public abstract void initiate();

    public abstract void handleMessage(Message var1);

    public final WorkflowState getState() {
        return this.state;
    }

    public final Future<ActivityResult> getFuture() {
        return this.future;
    }

    public String getType() {
        return this.getClass().getName();
    }

    public final UUID getId() {
        return this.id;
    }

    public String toString() {
        return "activity[" + this.getId() + "]:" + this.getType();
    }

    public int hashCode() {
        return HGUtils.hashIt(this.getId());
    }

    public boolean equals(Object x) {
        if (!(x instanceof Activity)) {
            return false;
        }
        return HGUtils.eq(this.getId(), ((Activity)x).getId());
    }
}

