/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.peer.workflow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.hypergraphdb.peer.workflow.ActivityStateListener;

public abstract class AbstractActivity<StateType>
implements Runnable {
    private AtomicReference<StateType> state = new AtomicReference();
    private HashMap<StateType, ArrayList<ActivityStateListener>> stateListeners = new HashMap();
    protected final StateType startState;
    protected final StateType endState;
    private CountDownLatch latch;
    protected CountDownLatch stateChangedLatch;

    public AbstractActivity(StateType start, StateType end) {
        this.startState = start;
        this.endState = end;
    }

    protected abstract void initiate();

    protected abstract void doRun();

    @Override
    public void run() {
        this.latch = new CountDownLatch(1);
        this.stateChangedLatch = new CountDownLatch(1);
        this.doRun();
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected boolean isStopped() {
        return this.endState.equals(this.getState());
    }

    protected void afterStateChanged(StateType newValue) {
        this.callStateListeners();
        if (this.latch != null && this.endState.equals(newValue)) {
            System.out.println("latch released");
            this.latch.countDown();
        }
        if (this.stateChangedLatch != null) {
            this.stateChangedLatch.countDown();
            this.stateChangedLatch = new CountDownLatch(1);
        }
    }

    protected boolean compareAndSetState(StateType oldState, StateType newState) {
        if (this.state.compareAndSet(oldState, newState)) {
            this.afterStateChanged(newState);
            return true;
        }
        return false;
    }

    protected StateType getState() {
        return this.state.get();
    }

    protected void setState(StateType newValue) {
        System.out.println("AbstractActivity: changing state from " + this.state.get() + " to " + newValue);
        this.state.set(newValue);
        this.afterStateChanged(newValue);
    }

    public void setStateListener(Object state, ActivityStateListener listener) {
        ArrayList<ActivityStateListener> list = this.stateListeners.get(state);
        if (list == null) {
            list = new ArrayList();
            this.stateListeners.put(state, list);
        }
        list.add(listener);
    }

    private void callStateListeners() {
        StateType newState = this.state.get();
        ArrayList<ActivityStateListener> list = this.stateListeners.get(newState);
        if (list != null) {
            for (ActivityStateListener listener : list) {
                listener.stateChanged(newState, this);
            }
        }
    }

    public StateType getStartState() {
        return this.startState;
    }

    public StateType getEndState() {
        return this.endState;
    }
}

