/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.peer.serializer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;

public class SerializationUtils {
    public static Integer deserializeInt(InputStream in) {
        try {
            int ch1 = in.read();
            int ch2 = in.read();
            int ch3 = in.read();
            int ch4 = in.read();
            int i = (ch1 & 0xFF) << 24 | (ch2 & 0xFF) << 16 | (ch3 & 0xFF) << 8 | ch4 & 0xFF;
            return new Integer(i);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static void serializeInt(OutputStream out, Integer data) {
        try {
            int v = data;
            out.write((byte)(v >>> 24 & 0xFF));
            out.write((byte)(v >>> 16 & 0xFF));
            out.write((byte)(v >>> 8 & 0xFF));
            out.write((byte)(v >>> 0 & 0xFF));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void serializeString(OutputStream out, String data) {
        byte[] byteData = data.getBytes();
        SerializationUtils.serializeInt(out, byteData.length);
        try {
            out.write(byteData);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String deserializeString(InputStream in) {
        byte[] byteData = new byte[SerializationUtils.deserializeInt(in).intValue()];
        try {
            in.read(byteData);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new String(byteData);
    }

    public static void serializeUUID(OutputStream out, UUID id) {
        long msb = id.getMostSignificantBits();
        long lsb = id.getLeastSignificantBits();
        byte[] data = new byte[]{(byte)(msb >>> 56), (byte)(msb >>> 48), (byte)(msb >>> 40), (byte)(msb >>> 32), (byte)(msb >>> 24), (byte)(msb >>> 16), (byte)(msb >>> 8), (byte)(msb >>> 0), (byte)(lsb >>> 56), (byte)(lsb >>> 48), (byte)(lsb >>> 40), (byte)(lsb >>> 32), (byte)(lsb >>> 24), (byte)(lsb >>> 16), (byte)(lsb >>> 8), (byte)(lsb >>> 0)};
        try {
            out.write(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static UUID deserializeUUID(InputStream in) {
        int i;
        byte[] data = new byte[16];
        try {
            in.read(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        long msb = 0L;
        long lsb = 0L;
        for (i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(data[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(data[i] & 0xFF);
        }
        return new UUID(msb, lsb);
    }
}

