/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.peer.serializer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.peer.SubgraphManager;
import org.hypergraphdb.peer.serializer.HGSerializer;
import org.hypergraphdb.peer.serializer.SubgraphSerializer;
import org.hypergraphdb.storage.BAUtils;
import org.hypergraphdb.storage.HGStoreSubgraph;
import org.hypergraphdb.storage.StorageGraph;

public class GenericSerializer
implements HGSerializer {
    private static final int NULL_MARKER = 2;
    private static final int TRANSIENT_SUBGRAPH = 0;
    private static final int SAVED_SUBGRAPH = 1;
    private static final int BYTE_BUFFER = 3;
    private static HyperGraph tempDB;
    private SubgraphSerializer serializer = new SubgraphSerializer();

    public static HyperGraph getTempDB() {
        return tempDB;
    }

    public static void setTempDB(HyperGraph tempDB) {
        GenericSerializer.tempDB = tempDB;
    }

    @Override
    public Object readData(InputStream in) throws IOException {
        StorageGraph result = null;
        int type = in.read();
        switch (type) {
            case 2: {
                return null;
            }
            case 0: {
                return (StorageGraph)this.serializer.readData(in);
            }
            case 1: {
                result = (StorageGraph)this.serializer.readData(in);
                SubgraphManager.store(result, tempDB.getStore());
                HGPersistentHandle theRoot = result.getRoots().iterator().next();
                Object resultObj = tempDB.get(theRoot);
                tempDB.remove(theRoot);
                return resultObj;
            }
            case 3: {
                int read;
                byte[] sizeB = new byte[4];
                in.read(sizeB, 0, 4);
                int size = BAUtils.readInt(sizeB, 0);
                byte[] buf = new byte[size];
                for (int sofar = 0; sofar < size; sofar += read) {
                    read = in.read(buf, sofar, size - sofar);
                    if (read != -1) continue;
                    throw new RuntimeException("Unexpected end of message stream ,expecting a byte[] of size " + size + ", but only got " + sofar + " bytes.");
                }
                return buf;
            }
        }
        throw new RuntimeException("Unknown serialization marker " + type);
    }

    @Override
    public void writeData(OutputStream out, Object data) throws IOException {
        StorageGraph subGraph;
        HGPersistentHandle tempHandle = null;
        if (data == null) {
            out.write(2);
            return;
        }
        if (data instanceof byte[]) {
            out.write(3);
            byte[] len = new byte[4];
            BAUtils.writeInt(((byte[])data).length, len, 0);
            out.write(len);
            out.write((byte[])data);
            return;
        }
        if (data instanceof StorageGraph) {
            out.write(0);
            subGraph = (StorageGraph)data;
        } else {
            out.write(1);
            tempHandle = tempDB.getPersistentHandle(tempDB.add(data));
            subGraph = new HGStoreSubgraph(tempHandle, tempDB.getStore());
        }
        this.serializer.writeData(out, subGraph);
        if (tempHandle != null) {
            tempDB.remove(tempHandle);
        }
    }
}

