/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.peer.serializer;

import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import org.hypergraphdb.handle.UUIDPersistentHandle;
import org.hypergraphdb.peer.protocol.SerializerManager;
import org.hypergraphdb.peer.serializer.GenericSerializer;
import org.hypergraphdb.peer.serializer.HGSerializer;
import org.hypergraphdb.peer.serializer.NullSerializer;
import org.hypergraphdb.peer.serializer.PersistentHandlerSerializer;
import org.hypergraphdb.peer.serializer.SerializationUtils;
import org.hypergraphdb.peer.serializer.SerializerMapper;
import org.hypergraphdb.peer.serializer.SubgraphSerializer;
import org.hypergraphdb.util.Pair;

public class DefaultSerializerManager
implements SerializerManager {
    public static final Integer NULL_SERIALIZER_ID = 0;
    public static final Integer GENERIC_SERIALIZER_ID = 1;
    public static final Integer PERSISTENT_HANDLE_SERIALIZER_ID = 100;
    public static final Integer SUBGRAPH_SERIALIZER_ID = 200;
    public static final Integer MESSAGE_SERIALIZER_ID = 201;
    private static HashMap<String, HGSerializer> wellKnownSerializers = new HashMap();
    private static HashMap<String, Integer> wellKnownSerializerIds = new HashMap();
    private static HashMap<Integer, HGSerializer> invertedWellKnownSerializerIds = new HashMap();
    private static LinkedList<Pair<SerializerMapper, Integer>> serializerMappers = new LinkedList();
    private static HashMap<Integer, SerializerMapper> invertedSerializerMappers = new HashMap();

    public DefaultSerializerManager() {
        DefaultSerializerManager.addWellknownSerializer("nullSerializer", new NullSerializer(), NULL_SERIALIZER_ID);
        DefaultSerializerManager.addWellknownSerializer("generic", new GenericSerializer(), GENERIC_SERIALIZER_ID);
        DefaultSerializerManager.addWellknownSerializer(UUIDPersistentHandle.class.getName(), new PersistentHandlerSerializer(), PERSISTENT_HANDLE_SERIALIZER_ID);
        DefaultSerializerManager.addSerializerMapper(new SubgraphSerializer(), SUBGRAPH_SERIALIZER_ID, null);
    }

    public static void addWellknownSerializer(String name, HGSerializer serializer, Integer id) {
        wellKnownSerializers.put(name, serializer);
        wellKnownSerializerIds.put(name, id);
        invertedWellKnownSerializerIds.put(id, serializer);
    }

    public static void addSerializerMapper(SerializerMapper mapper, Integer id, SerializerMapper addAfter) {
        if (addAfter == null) {
            serializerMappers.addFirst(new Pair<SerializerMapper, Integer>(mapper, id));
        } else {
            int index = serializerMappers.indexOf(addAfter);
            if (index >= 0) {
                serializerMappers.add(index + 1, new Pair<SerializerMapper, Integer>(mapper, id));
            } else {
                serializerMappers.add(new Pair<SerializerMapper, Integer>(mapper, id));
            }
        }
        invertedSerializerMappers.put(id, mapper);
    }

    @Override
    public HGSerializer getSerializer(InputStream in) {
        Integer serializerId = SerializationUtils.deserializeInt(in);
        return DefaultSerializerManager.getSerializerById(serializerId);
    }

    @Override
    public HGSerializer getSerializer(Object data) {
        if (data == null) {
            return wellKnownSerializers.get("nullSerializer");
        }
        return this.getSerializerByType(data.getClass());
    }

    @Override
    public HGSerializer getSerializerByType(Class<?> clazz) {
        HGSerializer serializer = null;
        serializer = this.getSerializerByTypeName(clazz.getName());
        if (serializer == null) {
            ListIterator iterator = serializerMappers.listIterator();
            while (serializer == null && iterator.hasNext()) {
                serializer = ((SerializerMapper)((Pair)iterator.next()).getFirst()).accept(clazz);
            }
        }
        if (serializer == null) {
            serializer = DefaultSerializerManager.getSerializerById(GENERIC_SERIALIZER_ID);
        }
        return serializer;
    }

    private HGSerializer getSerializerByTypeName(String typeName) {
        HGSerializer serializer = null;
        serializer = wellKnownSerializers.get(typeName);
        if (serializer == null && serializer == null) {
            serializer = wellKnownSerializers.get("beanSerializer");
        }
        return serializer;
    }

    public static HGSerializer getSerializerById(Integer serializerId) {
        SerializerMapper mapper;
        HGSerializer serializer = invertedWellKnownSerializerIds.get(serializerId);
        if (serializer == null && (mapper = invertedSerializerMappers.get(serializerId)) != null) {
            serializer = mapper.getSerializer();
        }
        return serializer;
    }
}

