/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.peer.replication;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hypergraphdb.peer.HGPeerIdentity;
import org.hypergraphdb.peer.HyperGraphPeer;
import org.hypergraphdb.peer.replication.CatchUpTaskClient;
import org.hypergraphdb.query.AnyAtomCondition;
import org.hypergraphdb.query.HGAtomPredicate;

public class Replication {
    private HGAtomPredicate atomInterests = new AnyAtomCondition();
    private Map<HGPeerIdentity, HGAtomPredicate> othersInterests = Collections.synchronizedMap(new HashMap());
    private HyperGraphPeer thisPeer;

    public Replication(HyperGraphPeer thisPeer) {
        this.thisPeer = thisPeer;
    }

    public static Replication get(HyperGraphPeer peer) {
        return (Replication)peer.getObjectContext().get(Replication.class.getName());
    }

    public HGAtomPredicate getAtomInterests() {
        return this.atomInterests;
    }

    public void setAtomInterests(HGAtomPredicate atomInterests) {
        this.atomInterests = atomInterests;
    }

    public Map<HGPeerIdentity, HGAtomPredicate> getOthersInterests() {
        return this.othersInterests;
    }

    public void catchUp() {
        CatchUpTaskClient catchUpTask = new CatchUpTaskClient(this.thisPeer, (Object)null);
        catchUpTask.run();
    }
}

