/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.peer.replication;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.hypergraphdb.HGHandle;
import org.hypergraphdb.HGPersistentHandle;
import org.hypergraphdb.HyperGraph;
import org.hypergraphdb.peer.HGPeerIdentity;
import org.hypergraphdb.peer.HyperGraphPeer;
import org.hypergraphdb.peer.InterestEvaluator;
import org.hypergraphdb.peer.Message;
import org.hypergraphdb.peer.Messages;
import org.hypergraphdb.peer.PeerFilter;
import org.hypergraphdb.peer.PeerRelatedActivity;
import org.hypergraphdb.peer.PeerRelatedActivityFactory;
import org.hypergraphdb.peer.Performative;
import org.hypergraphdb.peer.StorageService;
import org.hypergraphdb.peer.Structs;
import org.hypergraphdb.peer.log.Log;
import org.hypergraphdb.peer.log.LogEntry;
import org.hypergraphdb.peer.workflow.AbstractActivity;
import org.hypergraphdb.peer.workflow.Conversation;
import org.hypergraphdb.peer.workflow.ProposalConversation;
import org.hypergraphdb.peer.workflow.TaskActivity;

public class RememberTaskClient
extends TaskActivity<State> {
    private ArrayList<HGHandle> results;
    private InterestEvaluator evaluator;
    private Log log;
    private List<LogEntry> entries;
    private List<Object> batch;
    private AtomicInteger count = new AtomicInteger(1);
    PeerFilter peerFilter;
    private Object targetPeer;

    public RememberTaskClient(HyperGraphPeer thisPeer, Log log, Object targetPeer, List<Object> batch) {
        super(thisPeer, State.Started, State.Done);
        this.log = log;
        this.targetPeer = targetPeer;
        this.batch = batch;
    }

    public RememberTaskClient(HyperGraphPeer thisPeer, Object value, Log log, HyperGraph hg2, HGPersistentHandle handle, StorageService.Operation operation) {
        super(thisPeer, State.Started, State.Done);
        this.batch = new ArrayList<Object>();
        this.batch.add(new RememberEntity(handle, value, operation));
        this.log = log;
        this.evaluator = new InterestEvaluator(thisPeer.getPeerInterface(), hg2);
    }

    public RememberTaskClient(HyperGraphPeer thisPeer, Object value, Log log, HGPersistentHandle handle, Object targetPeer, StorageService.Operation operation) {
        super(thisPeer, State.Started, State.Done);
        this.batch = new ArrayList<Object>();
        this.batch.add(new RememberEntity(handle, value, operation));
        this.log = log;
        this.targetPeer = targetPeer;
    }

    public RememberTaskClient(HyperGraphPeer thisPeer, LogEntry entry, Object targetPeer, Log log) {
        super(thisPeer, State.Started, State.Done);
        this.entries = new ArrayList<LogEntry>();
        this.entries.add(entry);
        this.targetPeer = targetPeer;
        this.log = log;
        this.batch = new ArrayList<Object>();
        this.batch.add(new RememberEntity(null, null, entry.getOperation()));
    }

    @Override
    protected void initiate() {
        this.registerConversationHandler(State.Started, (Object)ProposalConversation.State.Proposed, "handleProposal", State.HandleProposal);
        this.registerConversationHandler(State.Accepted, (Object)ProposalConversation.State.Confirmed, "handleConfirm", State.HandleProposalResponse);
        this.registerConversationHandler(State.Accepted, (Object)ProposalConversation.State.Disconfirmed, "handleDisconfirm", State.HandleProposalResponse);
        PeerRelatedActivityFactory activityFactory = this.getPeerInterface().newSendActivityFactory();
        if (this.targetPeer == null) {
            this.peerFilter = this.getPeerInterface().newFilterActivity(this.evaluator);
        }
        if (this.entries == null) {
            this.entries = new ArrayList<LogEntry>();
            for (Object elem : this.batch) {
                RememberEntity entity = (RememberEntity)elem;
                HGPersistentHandle handle = entity.getHandle();
                if (handle == null) {
                    handle = this.getThisPeer().getGraph().getHandleFactory().makeHandle();
                    entity.setHandle(handle);
                }
                LogEntry entry = this.log.createLogEntry(handle, entity.getAtom(), entity.getOperation());
                Iterator<Object> targets = this.getTargets(handle);
                this.log.addEntry(entry, targets);
                this.entries.add(entry);
            }
        }
        if (this.peerFilter != null) {
            Iterator<Object> it = this.peerFilter.iterator();
            while (it.hasNext()) {
                Object target = it.next();
                this.sendCallForProposal(target, activityFactory);
            }
        } else {
            this.sendCallForProposal(this.targetPeer, activityFactory);
        }
        if (this.count.decrementAndGet() == 0) {
            this.setState(State.Done);
        }
    }

    private Iterator<Object> getTargets(HGPersistentHandle handle) {
        if (this.targetPeer == null) {
            this.evaluator.setHandle(handle);
            this.peerFilter.filterTargets();
            return this.peerFilter.iterator();
        }
        ArrayList<Object> targets = new ArrayList<Object>();
        targets.add(this.targetPeer);
        return targets.iterator();
    }

    private void sendCallForProposal(Object target, PeerRelatedActivityFactory activityFactory) {
        this.count.incrementAndGet();
        Message msg = Messages.createMessage(Performative.CallForProposal, "remember", this.getTaskId());
        LogEntry firstEntry = this.entries.get(0);
        LogEntry lastEntry = this.entries.get(this.entries.size() - 1);
        Structs.combine(msg, Structs.struct("content", Structs.struct("last_version", firstEntry.getLastTimestamp(this.getPeerInterface().getThisPeer().getIdentity(target)), "curr_version", lastEntry.getTimestamp())));
        PeerRelatedActivity activity = activityFactory.createActivity();
        activity.setTarget(target);
        activity.setMessage(msg);
        this.getThisPeer().getExecutorService().submit(activity);
    }

    @Override
    protected Conversation<?> createNewConversation(Message msg) {
        return new ProposalConversation(this, Messages.getSender(msg));
    }

    public State handleProposal(AbstractActivity<?> fromActivity) {
        System.out.println("RememeberTaskClient: handleProposal");
        ProposalConversation conversation = (ProposalConversation)fromActivity;
        Message reply = Messages.getReply(conversation.getMessage());
        ArrayList<Map<String, Object>> contents = new ArrayList<Map<String, Object>>();
        for (LogEntry entry : this.entries) {
            contents.add(Structs.struct(new Object[]{"operation", entry.getOperation(), "content", entry.getOperation() == StorageService.Operation.Remove ? entry.getHandle() : Structs.object(entry.getData())}));
        }
        Structs.combine(reply, Structs.struct("content", contents));
        conversation.accept(reply);
        return State.Accepted;
    }

    public State handleConfirm(AbstractActivity<?> fromActivity) {
        Message msg = ((ProposalConversation)fromActivity).getMessage();
        this.results = (ArrayList)Structs.getPart(msg, "content");
        HGPeerIdentity peerId = this.getPeerInterface().getThisPeer().getIdentity(Structs.getPart(msg, "reply-to"));
        this.log.confirmFromPeer(peerId, this.entries.get(this.entries.size() - 1).getTimestamp());
        if (this.count.decrementAndGet() == 0) {
            return State.Done;
        }
        return State.Started;
    }

    public State handleDisconfirm(AbstractActivity<?> fromActivity) {
        return State.Started;
    }

    public HGHandle getResult() {
        System.out.println("RESULT: " + this.results.get(0));
        return this.results.get(0);
    }

    public List<HGHandle> getResults() {
        return this.results;
    }

    public static class RememberEntity {
        private HGPersistentHandle handle;
        private Object atom;
        private StorageService.Operation operation;

        public RememberEntity(HGPersistentHandle handle, Object atom, StorageService.Operation operation) {
            this.handle = handle;
            this.atom = atom;
            this.operation = operation;
        }

        public HGPersistentHandle getHandle() {
            return this.handle;
        }

        public void setHandle(HGPersistentHandle handle) {
            this.handle = handle;
        }

        public Object getAtom() {
            return this.atom;
        }

        public void setAtom(Object atom) {
            this.atom = atom;
        }

        public StorageService.Operation getOperation() {
            return this.operation;
        }

        public void setOperation(StorageService.Operation operation) {
            this.operation = operation;
        }
    }

    protected static enum State {
        Started,
        Accepted,
        HandleProposal,
        HandleProposalResponse,
        Done;

    }
}

