/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.peer.replication;

import java.util.ArrayList;
import java.util.Collections;
import java.util.UUID;
import org.hypergraphdb.peer.HyperGraphPeer;
import org.hypergraphdb.peer.Message;
import org.hypergraphdb.peer.Structs;
import org.hypergraphdb.peer.log.LogEntry;
import org.hypergraphdb.peer.log.Timestamp;
import org.hypergraphdb.peer.replication.RememberTaskClient;
import org.hypergraphdb.peer.workflow.TaskActivity;
import org.hypergraphdb.peer.workflow.TaskFactory;
import org.hypergraphdb.query.HGAtomPredicate;

public class CatchUpTaskServer
extends TaskActivity<State> {
    public CatchUpTaskServer(HyperGraphPeer thisPeer, UUID taskId) {
        super(thisPeer, taskId, State.Started, State.Done);
    }

    @Override
    public void handleMessage(Message msg) {
        Timestamp lastTimestamp = (Timestamp)Structs.getPart(msg, "content", "last_version");
        HGAtomPredicate interest = (HGAtomPredicate)Structs.getPart(msg, "content", "interest");
        System.out.println("Catch up request from " + Structs.getPart(msg, "reply-to") + " starting from " + lastTimestamp + " with interest " + interest);
        ArrayList<LogEntry> entries = this.getThisPeer().getLog().getLogEntries(lastTimestamp, interest);
        Collections.sort(entries);
        for (LogEntry entry : entries) {
            System.out.println("Should catch up with: " + entry.getTimestamp());
            Object sendToPeer = Structs.getPart(msg, "reply-to");
            entry.setLastTimestamp(this.getPeerInterface().getThisPeer().getIdentity(sendToPeer), lastTimestamp);
            RememberTaskClient rememberTask = new RememberTaskClient(this.getThisPeer(), entry, sendToPeer, this.getThisPeer().getLog());
            rememberTask.run();
            lastTimestamp = entry.getTimestamp();
        }
        this.setState(State.Done);
    }

    public static class CatchUpTaskServerFactory
    implements TaskFactory {
        @Override
        public TaskActivity<?> newTask(HyperGraphPeer peer, UUID taskId, Object msg) {
            return new CatchUpTaskServer(peer, taskId);
        }
    }

    protected static enum State {
        Started,
        Done;

    }
}

