/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.peer.replication;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.hypergraphdb.peer.HyperGraphPeer;
import org.hypergraphdb.peer.Message;
import org.hypergraphdb.peer.Messages;
import org.hypergraphdb.peer.PeerFilter;
import org.hypergraphdb.peer.PeerRelatedActivity;
import org.hypergraphdb.peer.PeerRelatedActivityFactory;
import org.hypergraphdb.peer.Performative;
import org.hypergraphdb.peer.Structs;
import org.hypergraphdb.peer.replication.Replication;
import org.hypergraphdb.peer.workflow.AbstractActivity;
import org.hypergraphdb.peer.workflow.TaskActivity;

public class CatchUpTaskClient
extends TaskActivity<State> {
    private Object catchUpWith;
    private AtomicInteger count = new AtomicInteger(1);
    private HyperGraphPeer thisPeer;

    public CatchUpTaskClient(HyperGraphPeer thisPeer, Object catchUpWith) {
        super(thisPeer, State.Started, State.Done);
        this.catchUpWith = catchUpWith;
        this.thisPeer = thisPeer;
    }

    @Override
    protected void initiate() {
        System.out.println("Catching up...");
        PeerRelatedActivityFactory activityFactory = this.getPeerInterface().newSendActivityFactory();
        if (this.catchUpWith != null) {
            this.sendMessage(activityFactory, this.catchUpWith);
        } else {
            PeerFilter peerFilter = this.getPeerInterface().newFilterActivity(null);
            peerFilter.filterTargets();
            Iterator<Object> it = peerFilter.iterator();
            while (it.hasNext()) {
                Object target = it.next();
                this.sendMessage(activityFactory, target);
            }
        }
        this.setState(State.Done);
    }

    private void sendMessage(PeerRelatedActivityFactory activityFactory, Object target) {
        this.count.incrementAndGet();
        Message msg = Messages.createMessage(Performative.Request, "catchup", this.getTaskId());
        Structs.combine(msg, Structs.struct("content", Structs.struct("last_version", this.thisPeer.getLog().getLastFrom(target), "interest", Replication.get(this.thisPeer).getAtomInterests())));
        PeerRelatedActivity activity = activityFactory.createActivity();
        activity.setTarget(target);
        activity.setMessage(msg);
    }

    @Override
    public void stateChanged(Object newState, AbstractActivity<?> activity) {
    }

    public State handleConfirm(AbstractActivity<?> fromActivity) {
        if (this.count.decrementAndGet() == 0) {
            return State.Done;
        }
        return State.Started;
    }

    public State handleDisconfirm(AbstractActivity<?> fromActivity) {
        if (this.count.decrementAndGet() == 0) {
            return State.Done;
        }
        return State.Started;
    }

    protected static enum State {
        Started,
        Done;

    }
}

