/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.peer.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.hypergraphdb.peer.Message;
import org.hypergraphdb.peer.protocol.ObjectSerializer;
import org.hypergraphdb.peer.protocol.ProtocolUtils;

public class Protocol {
    private static final byte[] SIGNATURE = "HGBD".getBytes();

    public Message readMessage(InputStream in) throws IOException {
        Object content = null;
        if (!ProtocolUtils.verifySignature(in, SIGNATURE)) {
            throw new RuntimeException("ERROR: Signature does not match");
        }
        ObjectSerializer serializer = new ObjectSerializer();
        content = serializer.deserialize(in);
        if (content instanceof Map) {
            return new Message((Map)content);
        }
        throw new RuntimeException("Message content is null or not a map (i.e. a record-like object).");
    }

    public void writeMessage(OutputStream out, Message msg) throws IOException {
        this.writeSignature(out);
        ObjectSerializer serializer = new ObjectSerializer();
        serializer.serialize(out, msg);
    }

    private void writeSignature(OutputStream out) throws IOException {
        out.write(SIGNATURE);
    }
}

