/*
 * Decompiled with CFR 0.152.
 */
package org.hypergraphdb.peer.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.hypergraphdb.peer.protocol.ProtocolUtils;
import org.hypergraphdb.peer.serializer.CustomSerializedValue;
import org.hypergraphdb.peer.serializer.GenericSerializer;
import org.hypergraphdb.peer.serializer.JSONReader;
import org.hypergraphdb.peer.serializer.JSONWriter;
import org.hypergraphdb.peer.serializer.SerializationUtils;

public class ObjectSerializer {
    private static final byte[] DATA_SIGNATURE = "DATA".getBytes();
    private static final byte[] END_SIGNATURE = "END".getBytes();

    public void serialize(OutputStream out, Object data) throws IOException {
        ProtocolUtils.writeSignature(out, DATA_SIGNATURE);
        JSONWriter writer = new JSONWriter();
        SerializationUtils.serializeString(out, writer.write(data));
        ArrayList<CustomSerializedValue> customValues = writer.getCustomValues();
        SerializationUtils.serializeInt(out, customValues.size());
        if (customValues.size() > 0) {
            GenericSerializer serializer = new GenericSerializer();
            for (CustomSerializedValue value : customValues) {
                serializer.writeData(out, value.get());
            }
        }
        ProtocolUtils.writeSignature(out, END_SIGNATURE);
    }

    public Object deserialize(InputStream in) throws IOException {
        Object result = null;
        if (ProtocolUtils.verifySignature(in, DATA_SIGNATURE)) {
            JSONReader reader = new JSONReader();
            result = reader.read(SerializationUtils.deserializeString(in));
            int size = SerializationUtils.deserializeInt(in);
            if (size > 0) {
                HashMap<Integer, CustomSerializedValue> customValues = reader.getCustomValues();
                GenericSerializer serializer = new GenericSerializer();
                Integer i = 0;
                while (i < size) {
                    Object value = serializer.readData(in);
                    if (customValues.containsKey(i)) {
                        customValues.get(i).setValue(value);
                    }
                    Integer n = i;
                    Integer n2 = i = Integer.valueOf(i + 1);
                }
            }
            if (!ProtocolUtils.verifySignature(in, END_SIGNATURE)) {
                throw new RuntimeException("Message ending signature doesn't match.");
            }
        } else {
            throw new RuntimeException("Message starting signature doesn't match.");
        }
        return result;
    }
}

